/*
 * Decompiled with CFR 0.152.
 */
package org.jhotdraw8.graph.iterator;

import java.util.ArrayDeque;
import java.util.Deque;
import java.util.HashSet;
import java.util.Objects;
import java.util.function.Function;
import org.jhotdraw8.collection.enumerator.AbstractEnumerator;
import org.jhotdraw8.graph.algo.AddToSet;

public class BfsDfsVertexSpliterator<V>
extends AbstractEnumerator<V> {
    private final Function<V, Iterable<V>> nextFunction;
    private final Deque<V> deque;
    private final AddToSet<V> visited;
    private final boolean dfs;

    public BfsDfsVertexSpliterator(Function<V, Iterable<V>> nextFunction, V root, boolean dfs) {
        this(nextFunction, root, new HashSet()::add, dfs);
    }

    public BfsDfsVertexSpliterator(Function<V, Iterable<V>> nextFunction, V root, AddToSet<V> visited, boolean dfs) {
        super(Long.MAX_VALUE, 273);
        this.dfs = dfs;
        Objects.requireNonNull(nextFunction, "nextFunction");
        Objects.requireNonNull(root, "root");
        this.nextFunction = nextFunction;
        this.deque = new ArrayDeque<V>(16);
        this.visited = visited;
        if (visited.add(root)) {
            this.deque.addLast(root);
        }
    }

    public boolean moveNext() {
        if (this.deque.isEmpty()) {
            return false;
        }
        this.current = this.dfs ? this.deque.removeLast() : this.deque.removeFirst();
        for (V next : this.nextFunction.apply(this.current)) {
            if (!this.visited.add(next)) continue;
            this.deque.addLast(next);
        }
        return true;
    }
}

