/*
 * Decompiled with CFR 0.152.
 */
package org.jhotdraw8.graph.path;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.function.BiFunction;
import java.util.function.Predicate;
import java.util.function.Supplier;
import org.jhotdraw8.collection.pair.OrderedPair;
import org.jhotdraw8.collection.pair.SimpleOrderedPair;
import org.jhotdraw8.graph.Arc;
import org.jhotdraw8.graph.algo.AddToSet;
import org.jhotdraw8.icollection.VectorList;
import org.jhotdraw8.icollection.immutable.ImmutableList;
import org.jspecify.annotations.Nullable;

public interface ArcSequenceFinder<V, A, C extends Number> {
    public @Nullable OrderedPair<ImmutableList<Arc<V, A>>, C> findArcSequence(Iterable<V> var1, Predicate<V> var2, int var3, C var4, AddToSet<V> var5);

    default public @Nullable OrderedPair<ImmutableList<Arc<V, A>>, C> findArcSequence(V start, V goal, int maxDepth, C costLimit, AddToSet<V> visited) {
        return this.findArcSequence(VectorList.of((Object[])new Object[]{start}), goal::equals, maxDepth, costLimit, visited);
    }

    default public @Nullable OrderedPair<ImmutableList<Arc<V, A>>, C> findArcSequence(V start, V goal, int maxDepth, C costLimit) {
        return this.findArcSequence(VectorList.of((Object[])new Object[]{start}), goal::equals, maxDepth, costLimit, new HashSet()::add);
    }

    default public @Nullable OrderedPair<ImmutableList<Arc<V, A>>, C> findArcSequence(V start, V goal, C costLimit) {
        return this.findArcSequence(VectorList.of((Object[])new Object[]{start}), goal::equals, Integer.MAX_VALUE, costLimit, new HashSet()::add);
    }

    public @Nullable OrderedPair<ImmutableList<Arc<V, A>>, C> findArcSequenceOverWaypoints(Iterable<V> var1, int var2, C var3, Supplier<AddToSet<V>> var4);

    default public @Nullable OrderedPair<ImmutableList<Arc<V, A>>, C> findArcSequenceOverWaypoints(Iterable<V> waypoints, int maxDepth, C costLimit) {
        return this.findArcSequenceOverWaypoints(waypoints, maxDepth, costLimit, () -> new HashSet()::add);
    }

    default public @Nullable OrderedPair<ImmutableList<Arc<V, A>>, C> findArcSequenceOverWaypoints(Iterable<V> waypoints, C costLimit) {
        return this.findArcSequenceOverWaypoints(waypoints, Integer.MAX_VALUE, costLimit, () -> new HashSet()::add);
    }

    public static <VV, AA, CC extends Number> @Nullable OrderedPair<ImmutableList<Arc<VV, AA>>, CC> findArcSequenceOverWaypoints(Iterable<VV> waypoints, BiFunction<VV, VV, OrderedPair<ImmutableList<Arc<VV, AA>>, CC>> findArcSequenceFunction, CC zero, BiFunction<CC, CC, CC> sumFunction) {
        ArrayList sequence = new ArrayList();
        Object sum = zero;
        Object prev = null;
        int count = 0;
        for (VV next : waypoints) {
            if (prev != null) {
                OrderedPair<ImmutableList<Arc<VV, AA>>, CC> result = findArcSequenceFunction.apply(prev, next);
                if (result == null) {
                    return null;
                }
                List nextSequence = ((ImmutableList)result.first()).asList();
                sequence.addAll(nextSequence);
                sum = (Number)sumFunction.apply(sum, (Number)result.second());
            }
            prev = next;
            ++count;
        }
        if (count == 1) {
            return new SimpleOrderedPair((Object)VectorList.of(), zero);
        }
        return new SimpleOrderedPair((Object)VectorList.copyOf(sequence), sum);
    }
}

