/*
 * Decompiled with CFR 0.152.
 */
package org.jhotdraw8.graph.path;

import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.function.Predicate;
import org.jhotdraw8.base.function.Function3;
import org.jhotdraw8.collection.pair.OrderedPair;
import org.jhotdraw8.collection.spliterator.SpliteratorIterable;
import org.jhotdraw8.graph.Arc;
import org.jhotdraw8.graph.path.CombinedAllSequencesFinder;
import org.jhotdraw8.graph.path.algo.AllWalksSpliterator;
import org.jhotdraw8.graph.path.backlink.ArcBackLinkWithCost;
import org.jhotdraw8.icollection.immutable.ImmutableList;

public class SimpleCombinedAllSequencesFinder<V, A, C extends Number>
implements CombinedAllSequencesFinder<V, A, C> {
    private final C zero;
    private final Function<V, Iterable<Arc<V, A>>> nextArcsFunction;
    private final Function3<V, V, A, C> costFunction;
    private final BiFunction<C, C, C> sumFunction;

    public SimpleCombinedAllSequencesFinder(Function<V, Iterable<Arc<V, A>>> nextArcsFunction, C zero, Function3<V, V, A, C> costFunction, BiFunction<C, C, C> sumFunction) {
        this.zero = zero;
        this.nextArcsFunction = nextArcsFunction;
        this.costFunction = costFunction;
        this.sumFunction = sumFunction;
    }

    @Override
    public Iterable<OrderedPair<ImmutableList<Arc<V, A>>, C>> findAllArcSequences(Iterable<V> startVertices, Predicate<V> goalPredicate, int maxDepth, C costLimit) {
        return new SpliteratorIterable(() -> new AllWalksSpliterator(startVertices, goalPredicate, this.nextArcsFunction, backLink -> ArcBackLinkWithCost.toArrowSequence(backLink, (a, b) -> new Arc(a.getVertex(), b.getVertex(), b.getArrow())), maxDepth, (Number)costLimit, (Number)this.zero, this.costFunction, (BiFunction<Number, Number, Number>)this.sumFunction));
    }

    @Override
    public Iterable<OrderedPair<ImmutableList<A>, C>> findAllArrowSequences(Iterable<V> startVertices, Predicate<V> goalPredicate, int maxDepth, C costLimit) {
        return new SpliteratorIterable(() -> new AllWalksSpliterator(startVertices, goalPredicate, this.nextArcsFunction, backLink -> ArcBackLinkWithCost.toArrowSequence(backLink, (a, b) -> b.getArrow()), maxDepth, (Number)costLimit, (Number)this.zero, this.costFunction, (BiFunction<Number, Number, Number>)this.sumFunction));
    }

    @Override
    public Iterable<OrderedPair<ImmutableList<V>, C>> findAllVertexSequences(Iterable<V> startVertices, Predicate<V> goalPredicate, int maxDepth, C costLimit) {
        return new SpliteratorIterable(() -> new AllWalksSpliterator(startVertices, goalPredicate, this.nextArcsFunction, backLink -> ArcBackLinkWithCost.toVertexSequence(backLink, ArcBackLinkWithCost::getVertex), maxDepth, (Number)costLimit, (Number)this.zero, this.costFunction, (BiFunction<Number, Number, Number>)this.sumFunction));
    }
}

