/*
 * Decompiled with CFR 0.152.
 */
package org.jhotdraw8.graph.path;

import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.Supplier;
import org.jhotdraw8.base.function.Function3;
import org.jhotdraw8.collection.pair.OrderedPair;
import org.jhotdraw8.collection.pair.SimpleOrderedPair;
import org.jhotdraw8.graph.Arc;
import org.jhotdraw8.graph.algo.AddToSet;
import org.jhotdraw8.graph.path.ArcSequenceFinder;
import org.jhotdraw8.graph.path.ArrowSequenceFinder;
import org.jhotdraw8.graph.path.CombinedSequenceFinder;
import org.jhotdraw8.graph.path.VertexSequenceFinder;
import org.jhotdraw8.graph.path.algo.ArcPathSearchAlgo;
import org.jhotdraw8.graph.path.backlink.ArcBackLinkWithCost;
import org.jhotdraw8.icollection.immutable.ImmutableList;
import org.jspecify.annotations.Nullable;

public class SimpleCombinedSequenceFinder<V, A, C extends Number>
implements CombinedSequenceFinder<V, A, C> {
    private final C zero;
    private final Function<V, Iterable<Arc<V, A>>> nextArcsFunction;
    private final Function3<V, V, A, C> costFunction;
    private final BiFunction<C, C, C> sumFunction;
    private final ArcPathSearchAlgo<V, A, C> algo;

    public SimpleCombinedSequenceFinder(C zero, Function<V, Iterable<Arc<V, A>>> nextArcsFunction, Function3<V, V, A, C> costFunction, BiFunction<C, C, C> sumFunction, ArcPathSearchAlgo<V, A, C> algo) {
        if (((Number)zero).doubleValue() != 0.0) {
            throw new IllegalArgumentException("zero(" + String.valueOf(zero) + ") is != 0");
        }
        this.zero = zero;
        this.nextArcsFunction = nextArcsFunction;
        this.costFunction = costFunction;
        this.sumFunction = sumFunction;
        this.algo = algo;
    }

    public static <VV, AA> SimpleCombinedSequenceFinder<VV, AA, Integer> newIntCostInstance(Function<VV, Iterable<Arc<VV, AA>>> nextArcsFunction, Function3<VV, VV, AA, Integer> costFunction, ArcPathSearchAlgo<VV, AA, Integer> algo) {
        return new SimpleCombinedSequenceFinder<VV, AA, Integer>(0, nextArcsFunction, costFunction, Integer::sum, algo);
    }

    public static <VV, AA> SimpleCombinedSequenceFinder<VV, AA, Integer> newIntCostInstance(Function<VV, Iterable<Arc<VV, AA>>> nextArcsFunction, BiFunction<VV, VV, Integer> costFunction, ArcPathSearchAlgo<VV, AA, Integer> algo) {
        return new SimpleCombinedSequenceFinder<VV, AA, Integer>(0, nextArcsFunction, (u, v, a) -> (Integer)costFunction.apply(u, v), Integer::sum, algo);
    }

    public static <VV, AA> SimpleCombinedSequenceFinder<VV, AA, Integer> newIntCostInstance(Function<VV, Iterable<Arc<VV, AA>>> nextArcsFunction, ArcPathSearchAlgo<VV, AA, Integer> algo) {
        return new SimpleCombinedSequenceFinder<VV, AA, Integer>(0, nextArcsFunction, (u, v, a) -> 1, Integer::sum, algo);
    }

    public static <VV, AA> SimpleCombinedSequenceFinder<VV, AA, Double> newDoubleCostInstance(Function<VV, Iterable<Arc<VV, AA>>> nextArcsFunction, Function3<VV, VV, AA, Double> costFunction, ArcPathSearchAlgo<VV, AA, Double> algo) {
        return new SimpleCombinedSequenceFinder<VV, AA, Double>(0.0, nextArcsFunction, costFunction, Double::sum, algo);
    }

    public static <VV, AA> SimpleCombinedSequenceFinder<VV, AA, Long> newLongCostInstance(Function<VV, Iterable<Arc<VV, AA>>> nextArcsFunction, Function3<VV, VV, AA, Long> costFunction, ArcPathSearchAlgo<VV, AA, Long> algo) {
        return new SimpleCombinedSequenceFinder<VV, AA, Long>(0L, nextArcsFunction, costFunction, Long::sum, algo);
    }

    @Override
    public @Nullable OrderedPair<ImmutableList<Arc<V, A>>, C> findArcSequence(Iterable<V> startVertices, Predicate<V> goalPredicate, int maxDepth, C costLimit, AddToSet<V> visited) {
        return ArcBackLinkWithCost.toArrowSequence(this.algo.search(startVertices, goalPredicate, this.nextArcsFunction, maxDepth, this.zero, costLimit, this.costFunction, this.sumFunction, visited), (a, b) -> new Arc(a.getVertex(), b.getVertex(), b.getArrow()));
    }

    @Override
    public @Nullable OrderedPair<ImmutableList<Arc<V, A>>, C> findArcSequenceOverWaypoints(Iterable<V> waypoints, int maxDepth, C costLimit, Supplier<AddToSet<V>> visitedSetFactory) {
        return ArcSequenceFinder.findArcSequenceOverWaypoints(waypoints, (start, goal) -> this.findArcSequence(start, goal, maxDepth, costLimit, (AddToSet)visitedSetFactory.get()), this.zero, this.sumFunction);
    }

    @Override
    public @Nullable SimpleOrderedPair<ImmutableList<A>, C> findArrowSequence(Iterable<V> startVertices, Predicate<V> goalPredicate, int maxDepth, C costLimit, AddToSet<V> visited) {
        return ArcBackLinkWithCost.toArrowSequence(this.algo.search(startVertices, goalPredicate, this.nextArcsFunction, maxDepth, this.zero, costLimit, this.costFunction, this.sumFunction, visited), (a, b) -> b.getArrow());
    }

    @Override
    public @Nullable SimpleOrderedPair<ImmutableList<A>, C> findArrowSequenceOverWaypoints(Iterable<V> waypoints, int maxDepth, C costLimit, Supplier<AddToSet<V>> visitedSetFactory) {
        return ArrowSequenceFinder.findArrowSequenceOverWaypoints(waypoints, (start, goal) -> this.findArrowSequence(start, goal, maxDepth, costLimit, (AddToSet)visitedSetFactory.get()), this.zero, this.sumFunction);
    }

    @Override
    public @Nullable SimpleOrderedPair<ImmutableList<V>, C> findVertexSequence(Iterable<V> startVertices, Predicate<V> goalPredicate, int maxDepth, C costLimit, AddToSet<V> visited) {
        return ArcBackLinkWithCost.toVertexSequence(this.algo.search(startVertices, goalPredicate, this.nextArcsFunction, maxDepth, this.zero, costLimit, this.costFunction, this.sumFunction, visited), ArcBackLinkWithCost::getVertex);
    }

    @Override
    public @Nullable SimpleOrderedPair<ImmutableList<V>, C> findVertexSequenceOverWaypoints(Iterable<V> waypoints, int maxDepth, C costLimit, Supplier<AddToSet<V>> visitedSetFactory) {
        return VertexSequenceFinder.findVertexSequenceOverWaypoints(waypoints, (start, goal) -> this.findVertexSequence(start, goal, maxDepth, costLimit, (AddToSet)visitedSetFactory.get()), this.zero, this.sumFunction);
    }
}

