/*
 * Decompiled with CFR 0.152.
 */
package org.jhotdraw8.graph.path;

import java.util.Spliterator;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.Supplier;
import org.jhotdraw8.collection.pair.SimpleOrderedPair;
import org.jhotdraw8.graph.algo.AddToIntSet;
import org.jhotdraw8.graph.algo.AddToSet;
import org.jhotdraw8.graph.path.VertexSequenceFinder;
import org.jhotdraw8.graph.path.algo.IndexedVertexPathSearchAlgo;
import org.jhotdraw8.graph.path.backlink.IndexedVertexBackLinkWithCost;
import org.jhotdraw8.icollection.immutable.ImmutableList;
import org.jspecify.annotations.Nullable;

public class SimpleIndexedVertexSequenceFinder<C extends Number>
implements VertexSequenceFinder<Integer, C> {
    private final IndexedVertexPathSearchAlgo<C> algo;
    private final C zero;
    private final Function<Integer, Spliterator.OfInt> nextVerticesFunction;
    private final BiFunction<Integer, Integer, C> costFunction;
    private final BiFunction<C, C, C> sumFunction;

    public SimpleIndexedVertexSequenceFinder(C zero, Function<Integer, Spliterator.OfInt> nextVerticesFunction, BiFunction<Integer, Integer, C> costFunction, BiFunction<C, C, C> sumFunction, IndexedVertexPathSearchAlgo<C> algo) {
        this.zero = zero;
        this.nextVerticesFunction = nextVerticesFunction;
        this.costFunction = costFunction;
        this.sumFunction = sumFunction;
        this.algo = algo;
    }

    public static SimpleIndexedVertexSequenceFinder<Integer> newIntCostInstance(Function<Integer, Spliterator.OfInt> nextVerticesFunction, BiFunction<Integer, Integer, Integer> costFunction, IndexedVertexPathSearchAlgo<Integer> algo) {
        return new SimpleIndexedVertexSequenceFinder<Integer>(0, nextVerticesFunction, costFunction, Integer::sum, algo);
    }

    public static SimpleIndexedVertexSequenceFinder<Integer> newIntCostInstance(Function<Integer, Spliterator.OfInt> nextVerticesFunction, IndexedVertexPathSearchAlgo<Integer> algo) {
        return new SimpleIndexedVertexSequenceFinder<Integer>(0, nextVerticesFunction, (u, v) -> 1, Integer::sum, algo);
    }

    public static SimpleIndexedVertexSequenceFinder<Long> newLongCostInstance(Function<Integer, Spliterator.OfInt> nextVerticesFunction, BiFunction<Integer, Integer, Long> costFunction, IndexedVertexPathSearchAlgo<Long> algo) {
        return new SimpleIndexedVertexSequenceFinder<Long>(0L, nextVerticesFunction, costFunction, Long::sum, algo);
    }

    @Override
    public @Nullable SimpleOrderedPair<ImmutableList<Integer>, C> findVertexSequence(Iterable<Integer> startVertices, Predicate<Integer> goalPredicate, int maxDepth, C costLimit, AddToSet<Integer> visited) {
        AddToIntSet visitedAsInt = visited instanceof AddToIntSet ? (AddToIntSet)visited : visited::add;
        return IndexedVertexBackLinkWithCost.toVertexSequence(this.algo.search(startVertices, goalPredicate::test, this.nextVerticesFunction, maxDepth, this.zero, costLimit, this.costFunction, this.sumFunction, visitedAsInt), IndexedVertexBackLinkWithCost::getVertex);
    }

    @Override
    public @Nullable SimpleOrderedPair<ImmutableList<Integer>, C> findVertexSequenceOverWaypoints(Iterable<Integer> waypoints, int maxDepth, C costLimit, Supplier<AddToSet<Integer>> visitedSetFactory) {
        return VertexSequenceFinder.findVertexSequenceOverWaypoints(waypoints, (start, goal) -> this.findVertexSequence(start, goal, maxDepth, costLimit, (AddToSet)visitedSetFactory.get()), this.zero, this.sumFunction);
    }
}

