/*
 * Decompiled with CFR 0.152.
 */
package org.jhotdraw8.graph.path;

import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.Supplier;
import org.jhotdraw8.collection.pair.SimpleOrderedPair;
import org.jhotdraw8.graph.algo.AddToSet;
import org.jhotdraw8.graph.path.VertexSequenceFinder;
import org.jhotdraw8.graph.path.algo.VertexPathSearchAlgo;
import org.jhotdraw8.graph.path.backlink.VertexBackLinkWithCost;
import org.jhotdraw8.icollection.immutable.ImmutableList;
import org.jspecify.annotations.Nullable;

public class SimpleVertexSequenceFinder<V, C extends Number>
implements VertexSequenceFinder<V, C> {
    private final C zero;
    private final Function<V, Iterable<V>> nextVerticesFunction;
    private final BiFunction<V, V, C> costFunction;
    private final BiFunction<C, C, C> sumFunction;
    private final VertexPathSearchAlgo<V, C> algo;

    public SimpleVertexSequenceFinder(C zero, Function<V, Iterable<V>> nextVerticesFunction, BiFunction<V, V, C> costFunction, BiFunction<C, C, C> sumFunction, VertexPathSearchAlgo<V, C> algo) {
        this.zero = zero;
        this.nextVerticesFunction = nextVerticesFunction;
        this.costFunction = costFunction;
        this.sumFunction = sumFunction;
        this.algo = algo;
    }

    public static <VV> SimpleVertexSequenceFinder<VV, Integer> newIntCostInstance(Function<VV, Iterable<VV>> nextVerticesFunction, BiFunction<VV, VV, Integer> costFunction, VertexPathSearchAlgo<VV, Integer> algo) {
        return new SimpleVertexSequenceFinder<VV, Integer>(0, nextVerticesFunction, costFunction, Integer::sum, algo);
    }

    public static <VV> SimpleVertexSequenceFinder<VV, Integer> newIntCostInstance(Function<VV, Iterable<VV>> nextVerticesFunction, VertexPathSearchAlgo<VV, Integer> algo) {
        return new SimpleVertexSequenceFinder<Object, Integer>(0, nextVerticesFunction, (u, v) -> 1, Integer::sum, algo);
    }

    public static <VV> SimpleVertexSequenceFinder<VV, Long> newLongCostInstance(Function<VV, Iterable<VV>> nextVerticesFunction, BiFunction<VV, VV, Long> costFunction, VertexPathSearchAlgo<VV, Long> algo) {
        return new SimpleVertexSequenceFinder<VV, Long>(0L, nextVerticesFunction, costFunction, Long::sum, algo);
    }

    @Override
    public @Nullable SimpleOrderedPair<ImmutableList<V>, C> findVertexSequence(Iterable<V> startVertices, Predicate<V> goalPredicate, int maxDepth, C costLimit, AddToSet<V> visited) {
        return VertexBackLinkWithCost.toVertexSequence(this.algo.search(startVertices, goalPredicate, this.nextVerticesFunction, maxDepth, this.zero, costLimit, this.costFunction, this.sumFunction, visited), VertexBackLinkWithCost::getVertex);
    }

    @Override
    public @Nullable SimpleOrderedPair<ImmutableList<V>, C> findVertexSequenceOverWaypoints(Iterable<V> waypoints, int maxDepth, C costLimit, Supplier<AddToSet<V>> visitedSetFactory) {
        return VertexSequenceFinder.findVertexSequenceOverWaypoints(waypoints, (start, goal) -> this.findVertexSequence(start, goal, maxDepth, costLimit, (AddToSet)visitedSetFactory.get()), this.zero, this.sumFunction);
    }
}

