/*
 * Decompiled with CFR 0.152.
 */
package org.jhotdraw8.graph.path;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.function.BiFunction;
import java.util.function.Predicate;
import java.util.function.Supplier;
import org.jhotdraw8.collection.pair.OrderedPair;
import org.jhotdraw8.collection.pair.SimpleOrderedPair;
import org.jhotdraw8.graph.algo.AddToSet;
import org.jhotdraw8.icollection.VectorList;
import org.jhotdraw8.icollection.immutable.ImmutableList;
import org.jspecify.annotations.Nullable;

public interface VertexSequenceFinder<V, C extends Number> {
    public @Nullable SimpleOrderedPair<ImmutableList<V>, C> findVertexSequence(Iterable<V> var1, Predicate<V> var2, int var3, C var4, AddToSet<V> var5);

    default public @Nullable OrderedPair<ImmutableList<V>, C> findVertexSequence(Iterable<V> startVertices, Predicate<V> goalPredicate, int maxDepth, C costLimit) {
        return this.findVertexSequence((V)startVertices, (V)goalPredicate, maxDepth, costLimit, (AddToSet<V>)((AddToSet<Object>)new HashSet()::add));
    }

    default public @Nullable SimpleOrderedPair<ImmutableList<V>, C> findVertexSequence(Iterable<V> startVertices, Predicate<V> goalPredicate, C costLimit) {
        return this.findVertexSequence((V)startVertices, (V)goalPredicate, Integer.MAX_VALUE, costLimit, (AddToSet<V>)((AddToSet<Object>)new HashSet()::add));
    }

    default public @Nullable OrderedPair<ImmutableList<V>, C> findVertexSequence(V start, Predicate<V> goalPredicate, int maxDepth, C costLimit, AddToSet<V> visited) {
        return this.findVertexSequence((V)Collections.singletonList(start), (V)goalPredicate, maxDepth, costLimit, visited);
    }

    default public @Nullable OrderedPair<ImmutableList<V>, C> findVertexSequence(V start, Predicate<V> goalPredicate, int maxDepth, C costLimit) {
        return this.findVertexSequence((V)Collections.singletonList(start), (V)goalPredicate, maxDepth, costLimit, (AddToSet<V>)((AddToSet<Object>)new HashSet()::add));
    }

    default public @Nullable SimpleOrderedPair<ImmutableList<V>, C> findVertexSequence(V start, Predicate<V> goalPredicate, C costLimit) {
        return this.findVertexSequence((V)Collections.singletonList(start), (V)goalPredicate, Integer.MAX_VALUE, costLimit, (AddToSet<V>)((AddToSet<Object>)new HashSet()::add));
    }

    default public @Nullable SimpleOrderedPair<ImmutableList<V>, C> findVertexSequence(V start, V goal, int maxDepth, C costLimit, AddToSet<V> visited) {
        return this.findVertexSequence((V)VectorList.of((Object[])new Object[]{start}), (V)((Predicate<Object>)goal::equals), maxDepth, costLimit, visited);
    }

    default public @Nullable SimpleOrderedPair<ImmutableList<V>, C> findVertexSequence(V start, V goal, int maxDepth, C costLimit) {
        return this.findVertexSequence((V)VectorList.of((Object[])new Object[]{start}), (V)((Predicate<Object>)goal::equals), maxDepth, costLimit, (AddToSet<V>)((AddToSet<Object>)new HashSet()::add));
    }

    default public @Nullable SimpleOrderedPair<ImmutableList<V>, C> findVertexSequence(V start, V goal, C costLimit) {
        return this.findVertexSequence((V)VectorList.of((Object[])new Object[]{start}), (V)((Predicate<Object>)goal::equals), Integer.MAX_VALUE, costLimit, (AddToSet<V>)((AddToSet<Object>)new HashSet()::add));
    }

    public @Nullable SimpleOrderedPair<ImmutableList<V>, C> findVertexSequenceOverWaypoints(Iterable<V> var1, int var2, C var3, Supplier<AddToSet<V>> var4);

    default public @Nullable SimpleOrderedPair<ImmutableList<V>, C> findVertexSequenceOverWaypoints(Iterable<V> waypoints, int maxDepth, C costLimit) {
        return this.findVertexSequenceOverWaypoints(waypoints, maxDepth, costLimit, () -> new HashSet()::add);
    }

    default public @Nullable SimpleOrderedPair<ImmutableList<V>, C> findVertexSequenceOverWaypoints(Iterable<V> waypoints, C costLimit) {
        return this.findVertexSequenceOverWaypoints(waypoints, Integer.MAX_VALUE, costLimit, () -> new HashSet()::add);
    }

    public static <VV, CC extends Number> @Nullable SimpleOrderedPair<ImmutableList<VV>, CC> findVertexSequenceOverWaypoints(Iterable<VV> waypoints, BiFunction<VV, VV, OrderedPair<ImmutableList<VV>, CC>> findVertexSequenceFunction, CC zero, BiFunction<CC, CC, CC> sumFunction) {
        ArrayList sequence = new ArrayList();
        Object prev = null;
        Object sum = zero;
        int count = 0;
        for (VV next : waypoints) {
            if (prev != null) {
                OrderedPair<ImmutableList<VV>, CC> result = findVertexSequenceFunction.apply(prev, next);
                if (result == null) {
                    return null;
                }
                List nextSequence = ((ImmutableList)result.first()).asList();
                sequence.addAll(sequence.isEmpty() ? nextSequence : nextSequence.subList(1, nextSequence.size()));
                sum = (Number)sumFunction.apply(sum, (Number)result.second());
            }
            prev = next;
            ++count;
        }
        if (count == 1) {
            return new SimpleOrderedPair((Object)VectorList.of((Object[])new Object[]{prev}), zero);
        }
        return new SimpleOrderedPair((Object)VectorList.copyOf(sequence), sum);
    }
}

