/*
 * Decompiled with CFR 0.152.
 */
package org.jhotdraw8.graph.path.algo;

import java.util.ArrayDeque;
import java.util.Spliterator;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.function.IntConsumer;
import java.util.function.IntPredicate;
import org.jhotdraw8.collection.primitive.GrowableIntSet8Bit;
import org.jhotdraw8.graph.algo.AddToIntSet;
import org.jhotdraw8.graph.path.algo.AlgoArguments;
import org.jhotdraw8.graph.path.algo.IndexedVertexPathSearchAlgo;
import org.jhotdraw8.graph.path.backlink.IndexedVertexBackLink;
import org.jhotdraw8.graph.path.backlink.IndexedVertexBackLinkWithCost;
import org.jspecify.annotations.Nullable;

public class AnyIndexedVertexPathSearchAlgo<C extends Number>
implements IndexedVertexPathSearchAlgo<C> {
    @Override
    public @Nullable IndexedVertexBackLinkWithCost<C> search(Iterable<Integer> startVertices, IntPredicate goalPredicate, Function<Integer, Spliterator.OfInt> nextVerticesFunction, int maxDepth, C zero, C costLimit, BiFunction<Integer, Integer, C> costFunction, BiFunction<C, C, C> sumFunction, AddToIntSet visited) {
        AlgoArguments.checkZero(zero);
        return IndexedVertexBackLink.toIndexedVertexBackLinkWithCost(this.search(startVertices, goalPredicate, nextVerticesFunction, arg_0 -> ((GrowableIntSet8Bit)new GrowableIntSet8Bit()).addAsInt(arg_0), maxDepth), zero, costFunction, sumFunction);
    }

    public @Nullable IndexedVertexBackLink search(Iterable<Integer> startVertices, IntPredicate goalPredicate, Function<Integer, Spliterator.OfInt> nextVerticesFunction, AddToIntSet visited, int maxDepth) {
        AlgoArguments.checkMaxDepth(maxDepth);
        ArrayDeque<IndexedVertexBackLink> queue = new ArrayDeque<IndexedVertexBackLink>(32);
        MyIntConsumer consumer = new MyIntConsumer();
        for (Integer s : startVertices) {
            if (!visited.addAsInt(s)) continue;
            queue.add(new IndexedVertexBackLink(s, null));
        }
        while (!queue.isEmpty()) {
            IndexedVertexBackLink u = (IndexedVertexBackLink)queue.remove();
            int vertex = u.getVertex();
            if (goalPredicate.test(vertex)) {
                return u;
            }
            if (u.getDepth() >= maxDepth) continue;
            Spliterator.OfInt spliterator = nextVerticesFunction.apply(vertex);
            while (spliterator.tryAdvance(consumer)) {
                if (!visited.addAsInt(consumer.value)) continue;
                queue.add(new IndexedVertexBackLink(consumer.value, u));
            }
        }
        return null;
    }

    private static class MyIntConsumer
    implements IntConsumer {
        int value;

        private MyIntConsumer() {
        }

        @Override
        public void accept(int value) {
            this.value = value;
        }
    }
}

