/*
 * Decompiled with CFR 0.152.
 */
package org.jhotdraw8.graph.path.algo;

import java.util.Spliterator;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.function.IntConsumer;
import java.util.function.IntPredicate;
import org.jhotdraw8.collection.primitive.GrowableIntSet8Bit;
import org.jhotdraw8.collection.primitive.LongArrayDeque;
import org.jhotdraw8.graph.algo.AddToIntSet;
import org.jhotdraw8.graph.path.algo.AlgoArguments;
import org.jhotdraw8.graph.path.algo.IndexedVertexReachabilityAlgo;

public class AnyIndexedVertexReachabilityAlgo<C extends Number>
implements IndexedVertexReachabilityAlgo<C> {
    private static long newSearchNode(int vertex, int depth) {
        return (long)vertex << 32 | (long)depth;
    }

    private static int searchNodeGetDepth(long searchNode) {
        return (int)searchNode;
    }

    private static int searchNodeGetVertex(long searchNode) {
        return (int)(searchNode >> 32);
    }

    @Override
    public boolean tryToReach(Iterable<Integer> startVertices, IntPredicate goalPredicate, Function<Integer, Spliterator.OfInt> nextVerticesFunction, int maxDepth, C zero, C costLimit, BiFunction<Integer, Integer, C> costFunction, BiFunction<C, C, C> sumFunction, AddToIntSet visited) {
        AlgoArguments.checkZero(zero);
        return this.tryToReach(startVertices, goalPredicate, nextVerticesFunction, arg_0 -> ((GrowableIntSet8Bit)new GrowableIntSet8Bit()).addAsInt(arg_0), maxDepth);
    }

    public boolean tryToReach(Iterable<Integer> startVertices, IntPredicate goalPredicate, Function<Integer, Spliterator.OfInt> nextVerticesFunction, AddToIntSet visited, Integer maxDepth) {
        AlgoArguments.checkMaxDepth(maxDepth);
        LongArrayDeque queue = new LongArrayDeque(32);
        MyIntConsumer consumer = new MyIntConsumer();
        for (int s : startVertices) {
            if (!visited.addAsInt(s)) continue;
            queue.addLastAsLong(AnyIndexedVertexReachabilityAlgo.newSearchNode(s, 0));
        }
        while (!queue.isEmpty()) {
            long u = queue.removeFirstAsLong();
            int vertex = AnyIndexedVertexReachabilityAlgo.searchNodeGetVertex(u);
            if (goalPredicate.test(vertex)) {
                return true;
            }
            if (AnyIndexedVertexReachabilityAlgo.searchNodeGetDepth(u) >= maxDepth) continue;
            Spliterator.OfInt spliterator = nextVerticesFunction.apply(vertex);
            while (spliterator.tryAdvance(consumer)) {
                int v = consumer.value;
                if (!visited.addAsInt(v)) continue;
                queue.addLastAsLong(AnyIndexedVertexReachabilityAlgo.newSearchNode(v, AnyIndexedVertexReachabilityAlgo.searchNodeGetDepth(u) + 1));
            }
        }
        return false;
    }

    private static class MyIntConsumer
    implements IntConsumer {
        int value;

        private MyIntConsumer() {
        }

        @Override
        public void accept(int value) {
            this.value = value;
        }
    }
}

