/*
 * Decompiled with CFR 0.152.
 */
package org.jhotdraw8.graph.path.algo;

import java.util.Comparator;
import java.util.HashMap;
import java.util.PriorityQueue;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.function.Predicate;
import org.jhotdraw8.graph.algo.AddToSet;
import org.jhotdraw8.graph.path.algo.AlgoArguments;
import org.jhotdraw8.graph.path.algo.CheckedNonNegativeVertexCostFunction;
import org.jhotdraw8.graph.path.algo.VertexPathSearchAlgo;
import org.jhotdraw8.graph.path.backlink.AbstractBackLink;
import org.jhotdraw8.graph.path.backlink.AbstractBackLinkWithCost;
import org.jhotdraw8.graph.path.backlink.VertexBackLinkWithCost;
import org.jspecify.annotations.Nullable;

public class AnyShortestVertexPathSearchAlgo<V, C extends Number>
implements VertexPathSearchAlgo<V, C> {
    @Override
    public @Nullable VertexBackLinkWithCost<V, C> search(Iterable<V> startVertices, Predicate<V> goalPredicate, Function<V, Iterable<V>> nextVerticesFunction, int maxDepth, C zero, C costLimit, BiFunction<V, V, C> costFunction, BiFunction<C, C, C> sumFunction, AddToSet<V> visited) {
        AlgoArguments.checkMaxDepthMaxCostArguments(maxDepth, zero, costLimit);
        CheckedNonNegativeVertexCostFunction<V, C> costf = new CheckedNonNegativeVertexCostFunction<V, C>(zero, costFunction);
        PriorityQueue<VertexBackLinkWithCost> queue = new PriorityQueue<VertexBackLinkWithCost>(Comparator.comparing(AbstractBackLinkWithCost::getCost).thenComparing(AbstractBackLink::getDepth));
        HashMap<V, Object> costMap = new HashMap<V, Object>();
        for (V start : startVertices) {
            queue.add(new VertexBackLinkWithCost<V, C>(start, null, zero));
            costMap.put(start, zero);
        }
        while (!queue.isEmpty()) {
            VertexBackLinkWithCost u = (VertexBackLinkWithCost)queue.remove();
            if (goalPredicate.test(u.getVertex())) {
                return u;
            }
            if (u.getDepth() >= maxDepth) continue;
            for (V v : nextVerticesFunction.apply(u.getVertex())) {
                Number bestKnownCost = (Number)costMap.get(v);
                Number cost = (Number)sumFunction.apply(u.getCost(), costf.apply(u.getVertex(), (Object)v));
                if (bestKnownCost != null && ((Comparable)((Object)cost)).compareTo(bestKnownCost) >= 0 || ((Comparable)((Object)cost)).compareTo(costLimit) > 0) continue;
                costMap.put(v, cost);
                queue.add(new VertexBackLinkWithCost<V, Number>(v, u, cost));
            }
        }
        return null;
    }
}

