/*
 * Decompiled with CFR 0.152.
 */
package org.jhotdraw8.graph.path.algo;

import java.util.ArrayDeque;
import java.util.HashSet;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.function.Predicate;
import org.jhotdraw8.graph.algo.AddToSet;
import org.jhotdraw8.graph.path.algo.AlgoArguments;
import org.jhotdraw8.graph.path.algo.VertexPathSearchAlgo;
import org.jhotdraw8.graph.path.backlink.VertexBackLink;
import org.jhotdraw8.graph.path.backlink.VertexBackLinkWithCost;
import org.jspecify.annotations.Nullable;

public class AnyVertexPathSearchAlgo<V, C extends Number>
implements VertexPathSearchAlgo<V, C> {
    @Override
    public @Nullable VertexBackLinkWithCost<V, C> search(Iterable<V> startVertices, Predicate<V> goalPredicate, Function<V, Iterable<V>> nextVerticesFunction, int maxDepth, C zero, C costLimit, BiFunction<V, V, C> costFunction, BiFunction<C, C, C> sumFunction, AddToSet<V> visited) {
        AlgoArguments.checkZero(zero);
        return VertexBackLink.toVertexBackLinkWithCost(this.search(startVertices, goalPredicate, nextVerticesFunction, new HashSet()::add, maxDepth), zero, costFunction, sumFunction);
    }

    protected @Nullable VertexBackLink<V> search(Iterable<V> startVertices, Predicate<V> goalPredicate, Function<V, Iterable<V>> nextVerticesFunction, AddToSet<V> visited, int maxDepth) {
        AlgoArguments.checkMaxDepth(maxDepth);
        ArrayDeque<VertexBackLink<V>> queue = new ArrayDeque<VertexBackLink<V>>(16);
        for (V s : startVertices) {
            if (!visited.add(s)) continue;
            queue.add(new VertexBackLink<V>(s, null));
        }
        while (!queue.isEmpty()) {
            VertexBackLink u = (VertexBackLink)queue.remove();
            if (goalPredicate.test(u.getVertex())) {
                return u;
            }
            if (u.getDepth() >= maxDepth) continue;
            for (V v : nextVerticesFunction.apply(u.getVertex())) {
                if (!visited.add(v)) continue;
                queue.add(new VertexBackLink<V>(v, u));
            }
        }
        return null;
    }
}

