/*
 * Decompiled with CFR 0.152.
 */
package org.jhotdraw8.graph.path.algo;

import java.util.ArrayDeque;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import org.jhotdraw8.base.function.Function3;
import org.jhotdraw8.collection.pair.SimpleOrderedPair;
import org.jhotdraw8.graph.Arc;
import org.jhotdraw8.graph.algo.AddToSet;
import org.jhotdraw8.graph.path.algo.AlgoArguments;
import org.jhotdraw8.graph.path.algo.ArcPathSearchAlgo;
import org.jhotdraw8.graph.path.backlink.ArcBackLinkWithAncestorSet;
import org.jhotdraw8.graph.path.backlink.ArcBackLinkWithCost;
import org.jhotdraw8.icollection.ChampAddOnlySet;
import org.jspecify.annotations.Nullable;

public class UniqueArcPathSearchAlgo<V, A, C extends Number>
implements ArcPathSearchAlgo<V, A, C> {
    @Override
    public @Nullable ArcBackLinkWithCost<V, A, C> search(Iterable<V> startVertices, Predicate<V> goalPredicate, Function<V, Iterable<Arc<V, A>>> nextArcsFunction, int maxDepth, C zero, C costLimit, Function3<V, V, A, C> costFunction, BiFunction<C, C, C> sumFunction, AddToSet<V> visited) {
        AlgoArguments.checkZero(zero);
        return ArcBackLinkWithAncestorSet.toArcBackLinkWithCost(this.search(startVertices, goalPredicate, nextArcsFunction, maxDepth), zero, costFunction, sumFunction);
    }

    public @Nullable ArcBackLinkWithAncestorSet<V, A> search(Iterable<V> startVertices, Predicate<V> goalPredicate, Function<V, Iterable<Arc<V, A>>> nextArcsFunction, int maxDepth) {
        ArcBackLinkWithAncestorSet result = null;
        for (Object startVertex : StreamSupport.stream(startVertices.spliterator(), false).collect(Collectors.toCollection(LinkedHashSet::new))) {
            SimpleOrderedPair innerResult = this.searchSingleStartVertex(startVertex, goalPredicate, nextArcsFunction, maxDepth);
            SearchResultType resultType = (SearchResultType)((Object)innerResult.first());
            @Nullable ArcBackLinkWithAncestorSet backLink = (ArcBackLinkWithAncestorSet)innerResult.second();
            if (resultType == SearchResultType.FAILURE_NOT_UNIQUE) {
                return null;
            }
            if (resultType != SearchResultType.SUCCESS_UNIQUE_PATH) continue;
            if (result == null) {
                result = backLink;
                continue;
            }
            return null;
        }
        return result;
    }

    private SimpleOrderedPair<SearchResultType, @Nullable ArcBackLinkWithAncestorSet<V, A>> searchSingleStartVertex(V startVertex, Predicate<V> goalPredicate, Function<V, Iterable<Arc<V, A>>> nextArcsFunction, int maxDepth) {
        AlgoArguments.checkMaxDepth(maxDepth);
        ArrayDeque<ArcBackLinkWithAncestorSet<V, A>> queue = new ArrayDeque<ArcBackLinkWithAncestorSet<V, A>>(16);
        LinkedHashMap<V, Integer> visitedCount = new LinkedHashMap<V, Integer>(16);
        visitedCount.put(startVertex, 1);
        queue.add(new ArcBackLinkWithAncestorSet<V, Object>(startVertex, null, null, ChampAddOnlySet.of((Object[])new Object[]{startVertex})));
        ArcBackLinkWithAncestorSet found = null;
        while (!queue.isEmpty()) {
            ArcBackLinkWithAncestorSet u = (ArcBackLinkWithAncestorSet)queue.remove();
            if (goalPredicate.test(u.getVertex())) {
                if (found != null) {
                    return new SimpleOrderedPair((Object)SearchResultType.FAILURE_NOT_UNIQUE, null);
                }
                found = u;
            }
            if (u.getDepth() >= maxDepth) continue;
            ChampAddOnlySet uAncestors = u.removeAncestors();
            for (Arc<V, A> v : nextArcsFunction.apply(u.getVertex())) {
                ChampAddOnlySet vAncestors = uAncestors.add(v.getEnd());
                if (vAncestors == uAncestors || visitedCount.merge(v.getEnd(), 1, Integer::sum) != 1) continue;
                ArcBackLinkWithAncestorSet<V, A> backLink = new ArcBackLinkWithAncestorSet<V, A>(v.getEnd(), v.getArrow(), u, vAncestors);
                queue.add(backLink);
            }
        }
        for (ArcBackLinkWithAncestorSet node = found; node != null; node = (ArcBackLinkWithAncestorSet)node.getParent()) {
            if ((Integer)visitedCount.get(node.getVertex()) <= 1) continue;
            return new SimpleOrderedPair((Object)SearchResultType.FAILURE_NOT_UNIQUE, null);
        }
        return found == null ? new SimpleOrderedPair((Object)SearchResultType.FAILURE_NO_PATH, null) : new SimpleOrderedPair((Object)SearchResultType.SUCCESS_UNIQUE_PATH, (Object)found);
    }

    private static enum SearchResultType {
        SUCCESS_UNIQUE_PATH,
        FAILURE_NO_PATH,
        FAILURE_NOT_UNIQUE;

    }
}

