/*
 * Decompiled with CFR 0.152.
 */
package org.jhotdraw8.graph.path.algo;

import java.util.ArrayDeque;
import java.util.LinkedHashMap;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.function.Predicate;
import org.jhotdraw8.base.function.Function3;
import org.jhotdraw8.graph.Arc;
import org.jhotdraw8.graph.algo.AddToSet;
import org.jhotdraw8.graph.path.algo.AlgoArguments;
import org.jhotdraw8.graph.path.algo.ArcPathSearchAlgo;
import org.jhotdraw8.graph.path.backlink.ArcBackLink;
import org.jhotdraw8.graph.path.backlink.ArcBackLinkWithCost;
import org.jspecify.annotations.Nullable;

public class UniqueOnAcyclicGraphArcPathSearchAlgo<V, A, C extends Number>
implements ArcPathSearchAlgo<V, A, C> {
    @Override
    public @Nullable ArcBackLinkWithCost<V, A, C> search(Iterable<V> startVertices, Predicate<V> goalPredicate, Function<V, Iterable<Arc<V, A>>> nextArcsFunction, int maxDepth, C zero, C costLimit, Function3<V, V, A, C> costFunction, BiFunction<C, C, C> sumFunction, AddToSet<V> visited) {
        AlgoArguments.checkZero(zero);
        return ArcBackLink.toArcBackLinkWithCost(this.search(startVertices, goalPredicate, nextArcsFunction, maxDepth), zero, costFunction, sumFunction);
    }

    public @Nullable ArcBackLink<V, A> search(Iterable<V> startVertices, Predicate<V> goalPredicate, Function<V, Iterable<Arc<V, A>>> nextArcsFunction, int maxDepth) {
        AlgoArguments.checkMaxDepth(maxDepth);
        ArrayDeque<ArcBackLink<V, A>> queue = new ArrayDeque<ArcBackLink<V, A>>(16);
        LinkedHashMap<V, Integer> visitedCount = new LinkedHashMap<V, Integer>(16);
        for (V s : startVertices) {
            if (visitedCount.put(s, 1) != null) continue;
            queue.add(new ArcBackLink<V, Object>(s, null, null));
        }
        ArcBackLink found = null;
        while (!queue.isEmpty()) {
            ArcBackLink u = (ArcBackLink)queue.remove();
            if (goalPredicate.test(u.getVertex())) {
                if (found != null) {
                    return null;
                }
                found = u;
            }
            if (u.getDepth() >= maxDepth) continue;
            for (Arc<V, A> v : nextArcsFunction.apply(u.getVertex())) {
                if (visitedCount.merge(v.getEnd(), 1, Integer::sum) != 1) continue;
                queue.add(new ArcBackLink<V, A>(v.getEnd(), v.getArrow(), u));
            }
        }
        for (ArcBackLink node = found; node != null; node = (ArcBackLink)node.getParent()) {
            if ((Integer)visitedCount.get(node.getVertex()) <= 1) continue;
            return null;
        }
        return found;
    }
}

