/*
 * Decompiled with CFR 0.152.
 */
package org.jhotdraw8.graph.path.algo;

import java.util.ArrayDeque;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.function.Predicate;
import org.jhotdraw8.graph.algo.AddToSet;
import org.jhotdraw8.graph.path.algo.AlgoArguments;
import org.jhotdraw8.graph.path.algo.VertexPathSearchAlgo;
import org.jhotdraw8.graph.path.backlink.VertexBackLinkWithCost;
import org.jspecify.annotations.Nullable;

public class UniqueOrOneHopVertexPathSearchAlgo<V, C extends Number>
implements VertexPathSearchAlgo<V, C> {
    @Override
    public @Nullable VertexBackLinkWithCost<V, C> search(Iterable<V> startVertices, Predicate<V> goalPredicate, Function<V, Iterable<V>> nextVerticesFunction, int maxDepth, C zero, C costLimit, BiFunction<V, V, C> costFunction, BiFunction<C, C, C> sumFunction, AddToSet<V> visited) {
        return this.search(startVertices, goalPredicate, nextVerticesFunction, new HashSet(16)::add, maxDepth, zero, costFunction, sumFunction);
    }

    public @Nullable VertexBackLinkWithCost<V, C> search(Iterable<V> startVertices, Predicate<V> goalPredicate, Function<V, Iterable<V>> nextVerticesFunction, AddToSet<V> visited, int maxDepth, C zero, BiFunction<V, V, C> costFunction, BiFunction<C, C, C> sumFunction) {
        AlgoArguments.checkZero(zero);
        AlgoArguments.checkMaxDepth(maxDepth);
        ArrayDeque<VertexBackLinkWithCost<V, C>> queue = new ArrayDeque<VertexBackLinkWithCost<V, C>>(16);
        for (V start : startVertices) {
            VertexBackLinkWithCost<V, C> rootBackLink = new VertexBackLinkWithCost<V, C>(start, null, zero);
            if (!visited.add(start)) continue;
            queue.add(rootBackLink);
        }
        VertexBackLinkWithCost found = null;
        LinkedHashSet<V> nonUnique = new LinkedHashSet<V>();
        while (!queue.isEmpty()) {
            VertexBackLinkWithCost u = (VertexBackLinkWithCost)queue.remove();
            if (goalPredicate.test(u.getVertex())) {
                if (found != null) {
                    return null;
                }
                if (u.getDepth() <= 1) {
                    return u;
                }
                found = u;
            }
            if (u.getDepth() >= maxDepth) continue;
            for (V v : nextVerticesFunction.apply(u.getVertex())) {
                if (visited.add(v)) {
                    VertexBackLinkWithCost<V, Number> backLink = new VertexBackLinkWithCost<V, Number>(v, u, (Number)sumFunction.apply(u.getCost(), (Number)costFunction.apply(u.getVertex(), v)));
                    queue.add(backLink);
                    continue;
                }
                nonUnique.add(v);
            }
        }
        for (VertexBackLinkWithCost node = found; node != null; node = (VertexBackLinkWithCost)node.getParent()) {
            if (!nonUnique.contains(node.getVertex())) continue;
            return null;
        }
        return found;
    }
}

