/*
 * Decompiled with CFR 0.152.
 */
package org.jhotdraw8.graph.path.algo;

import java.util.Comparator;
import java.util.HashMap;
import java.util.PriorityQueue;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.function.Predicate;
import org.jhotdraw8.base.function.Function3;
import org.jhotdraw8.graph.Arc;
import org.jhotdraw8.graph.algo.AddToSet;
import org.jhotdraw8.graph.path.algo.AlgoArguments;
import org.jhotdraw8.graph.path.algo.ArcPathSearchAlgo;
import org.jhotdraw8.graph.path.algo.CheckedNonNegativeArcCostFunction3;
import org.jhotdraw8.graph.path.algo.CostData;
import org.jhotdraw8.graph.path.backlink.AbstractBackLink;
import org.jhotdraw8.graph.path.backlink.AbstractBackLinkWithCost;
import org.jhotdraw8.graph.path.backlink.ArcBackLinkWithCost;
import org.jspecify.annotations.Nullable;

public class UniqueShortestArcPathSearchAlgo<V, A, C extends Number>
implements ArcPathSearchAlgo<V, A, C> {
    @Override
    public @Nullable ArcBackLinkWithCost<V, A, C> search(Iterable<V> startVertices, Predicate<V> goalPredicate, Function<V, Iterable<Arc<V, A>>> nextArcsFunction, int maxDepth, C zero, C costLimit, Function3<V, V, A, C> costFunction, BiFunction<C, C, C> sumFunction, AddToSet<V> visited) {
        AlgoArguments.checkMaxDepthMaxCostArguments(maxDepth, zero, costLimit);
        CheckedNonNegativeArcCostFunction3<V, A, C> costf = new CheckedNonNegativeArcCostFunction3<V, A, C>(zero, costFunction);
        PriorityQueue<ArcBackLinkWithCost> queue = new PriorityQueue<ArcBackLinkWithCost>(Comparator.comparing(AbstractBackLinkWithCost::getCost).thenComparing(AbstractBackLink::getDepth));
        HashMap<V, CostData<C>> costMap = new HashMap<V, CostData<C>>();
        CostData<Object> infiniteCost = new CostData<Object>(null, 0);
        for (V start : startVertices) {
            queue.add(new ArcBackLinkWithCost<V, Object, C>(start, null, null, zero));
            costMap.put(start, new CostData<C>(zero, 1));
        }
        C maxCost = costLimit;
        ArcBackLinkWithCost found = null;
        while (!queue.isEmpty()) {
            ArcBackLinkWithCost u = (ArcBackLinkWithCost)queue.remove();
            Object costToU = u.getCost();
            if (goalPredicate.test(u.getVertex())) {
                if (found == null) {
                    found = u;
                    maxCost = costToU;
                } else if (((Comparable)costToU).compareTo(maxCost) == 0) {
                    return null;
                }
            }
            if (found != null && ((Comparable)costToU).compareTo(maxCost) > 0) break;
            if (u.getDepth() >= maxDepth) continue;
            for (Arc<V, A> v : nextArcsFunction.apply(u.getVertex())) {
                int compare;
                CostData<Object> costDataV = costMap.getOrDefault(v.getEnd(), infiniteCost);
                Number bestKnownCost = costDataV.getCost();
                Number cost = (Number)sumFunction.apply(costToU, costf.apply(u.getVertex(), (Object)v.getEnd(), (Object)v.getArrow()));
                if (((Comparable)((Object)cost)).compareTo(maxCost) > 0) continue;
                int n = compare = bestKnownCost == null ? -1 : ((Comparable)((Object)cost)).compareTo(bestKnownCost);
                if (compare < 0) {
                    costMap.put(v.getEnd(), new CostData<Number>(cost, 1));
                    queue.add(new ArcBackLinkWithCost<V, A, Number>(v.getEnd(), v.getArrow(), u, cost));
                    continue;
                }
                if (compare != 0) continue;
                costDataV.increaseVisitCount();
            }
        }
        for (ArcBackLinkWithCost node = found; node != null; node = (ArcBackLinkWithCost)node.getParent()) {
            if (((CostData)costMap.get(node.getVertex())).getVisiCount() == 1) continue;
            return null;
        }
        return found;
    }
}

