/*
 * Decompiled with CFR 0.152.
 */
package org.jhotdraw8.graph.path.algo;

import java.util.Comparator;
import java.util.HashMap;
import java.util.PriorityQueue;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.function.Predicate;
import org.jhotdraw8.graph.algo.AddToSet;
import org.jhotdraw8.graph.path.algo.AlgoArguments;
import org.jhotdraw8.graph.path.algo.CheckedNonNegativeVertexCostFunction;
import org.jhotdraw8.graph.path.algo.CostData;
import org.jhotdraw8.graph.path.algo.VertexPathSearchAlgo;
import org.jhotdraw8.graph.path.backlink.AbstractBackLink;
import org.jhotdraw8.graph.path.backlink.AbstractBackLinkWithCost;
import org.jhotdraw8.graph.path.backlink.VertexBackLinkWithCost;
import org.jspecify.annotations.Nullable;

public class UniqueShortestVertexPathSearchAlgo<V, C extends Number>
implements VertexPathSearchAlgo<V, C> {
    @Override
    public @Nullable VertexBackLinkWithCost<V, C> search(Iterable<V> startVertices, Predicate<V> goalPredicate, Function<V, Iterable<V>> nextVertices, int maxDepth, C zero, C costLimit, BiFunction<V, V, C> costFunction, BiFunction<C, C, C> sumFunction, AddToSet<V> visited) {
        AlgoArguments.checkMaxDepthMaxCostArguments(maxDepth, zero, costLimit);
        CheckedNonNegativeVertexCostFunction<V, C> costf = new CheckedNonNegativeVertexCostFunction<V, C>(zero, costFunction);
        PriorityQueue<VertexBackLinkWithCost> queue = new PriorityQueue<VertexBackLinkWithCost>(Comparator.comparing(AbstractBackLinkWithCost::getCost).thenComparing(AbstractBackLink::getDepth));
        HashMap<V, CostData<C>> costMap = new HashMap<V, CostData<C>>();
        CostData<Object> infiniteCost = new CostData<Object>(null, 0);
        for (V start : startVertices) {
            queue.add(new VertexBackLinkWithCost<V, C>(start, null, zero));
            costMap.put(start, new CostData<C>(zero, 1));
        }
        C maxCost = costLimit;
        VertexBackLinkWithCost found = null;
        while (!queue.isEmpty()) {
            VertexBackLinkWithCost u = (VertexBackLinkWithCost)queue.remove();
            Object costToU = u.getCost();
            if (goalPredicate.test(u.getVertex())) {
                if (found == null) {
                    found = u;
                    maxCost = costToU;
                } else if (((Comparable)costToU).compareTo(maxCost) == 0) {
                    return null;
                }
            }
            if (found != null && ((Comparable)costToU).compareTo(maxCost) > 0) break;
            if (u.getDepth() >= maxDepth) continue;
            for (V v : nextVertices.apply(u.getVertex())) {
                int compare;
                CostData<Object> costDataV = costMap.getOrDefault(v, infiniteCost);
                Number bestKnownCost = costDataV.getCost();
                Number cost = (Number)sumFunction.apply(costToU, costf.apply(u.getVertex(), (Object)v));
                if (((Comparable)((Object)cost)).compareTo(maxCost) > 0) continue;
                int n = compare = bestKnownCost == null ? -1 : ((Comparable)((Object)cost)).compareTo(bestKnownCost);
                if (compare < 0) {
                    costMap.put(v, new CostData<Number>(cost, 1));
                    queue.add(new VertexBackLinkWithCost<V, Number>(v, u, cost));
                    continue;
                }
                if (compare != 0) continue;
                costDataV.increaseVisitCount();
            }
        }
        for (VertexBackLinkWithCost node = found; node != null; node = (VertexBackLinkWithCost)node.getParent()) {
            if (((CostData)costMap.get(node.getVertex())).getVisiCount() == 1) continue;
            return null;
        }
        return found;
    }
}

