/*
 * Decompiled with CFR 0.152.
 */
package org.jhotdraw8.graph.path.algo;

import java.util.ArrayDeque;
import java.util.LinkedHashMap;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import org.jhotdraw8.collection.pair.SimpleOrderedPair;
import org.jhotdraw8.graph.algo.AddToSet;
import org.jhotdraw8.graph.path.algo.AlgoArguments;
import org.jhotdraw8.graph.path.algo.VertexPathSearchAlgo;
import org.jhotdraw8.graph.path.backlink.VertexBackLinkWithAncestorSet;
import org.jhotdraw8.graph.path.backlink.VertexBackLinkWithCost;
import org.jhotdraw8.icollection.ChampAddOnlySet;
import org.jspecify.annotations.Nullable;

public class UniqueVertexPathSearchAlgo<V, C extends Number>
implements VertexPathSearchAlgo<V, C> {
    @Override
    public @Nullable VertexBackLinkWithCost<V, C> search(Iterable<V> startVertices, Predicate<V> goalPredicate, Function<V, Iterable<V>> nextVerticesFunction, int maxDepth, C zero, C costLimit, BiFunction<V, V, C> costFunction, BiFunction<C, C, C> sumFunction, AddToSet<V> visited) {
        AlgoArguments.checkZero(zero);
        return VertexBackLinkWithAncestorSet.toVertexBackLinkWithCost(this.search(startVertices, goalPredicate, nextVerticesFunction, maxDepth), zero, costFunction, sumFunction);
    }

    public @Nullable VertexBackLinkWithAncestorSet<V> search(Iterable<V> startVertices, Predicate<V> goalPredicate, Function<V, Iterable<V>> nextVerticesFunction, int maxDepth) {
        AlgoArguments.checkMaxDepth(maxDepth);
        VertexBackLinkWithAncestorSet result = null;
        for (Object startVertex : StreamSupport.stream(startVertices.spliterator(), false).collect(Collectors.toSet())) {
            SimpleOrderedPair innerResult = this.searchSingleStartVertex(startVertex, goalPredicate, nextVerticesFunction, maxDepth);
            SearchResultType resultType = (SearchResultType)((Object)innerResult.first());
            @Nullable VertexBackLinkWithAncestorSet backLink = (VertexBackLinkWithAncestorSet)innerResult.second();
            if (resultType == SearchResultType.FAILURE_NOT_UNIQUE) {
                return null;
            }
            if (resultType != SearchResultType.SUCCESS_UNIQUE_PATH) continue;
            if (result == null) {
                result = backLink;
                continue;
            }
            return null;
        }
        return result;
    }

    private SimpleOrderedPair<SearchResultType, @Nullable VertexBackLinkWithAncestorSet<V>> searchSingleStartVertex(V startVertex, Predicate<V> goalPredicate, Function<V, Iterable<V>> nextVerticesFunction, int maxDepth) {
        ArrayDeque<VertexBackLinkWithAncestorSet<V>> queue = new ArrayDeque<VertexBackLinkWithAncestorSet<V>>(16);
        LinkedHashMap<V, Integer> visitedCount = new LinkedHashMap<V, Integer>(16);
        visitedCount.put(startVertex, 1);
        queue.add(new VertexBackLinkWithAncestorSet<V>(startVertex, null, ChampAddOnlySet.of((Object[])new Object[]{startVertex})));
        VertexBackLinkWithAncestorSet found = null;
        while (!queue.isEmpty()) {
            VertexBackLinkWithAncestorSet u = (VertexBackLinkWithAncestorSet)queue.remove();
            if (goalPredicate.test(u.getVertex())) {
                if (found != null) {
                    return new SimpleOrderedPair((Object)SearchResultType.FAILURE_NOT_UNIQUE, null);
                }
                found = u;
            }
            if (u.getDepth() >= maxDepth) continue;
            ChampAddOnlySet uAncestors = u.removeAncestors();
            for (V v : nextVerticesFunction.apply(u.getVertex())) {
                ChampAddOnlySet vAncestors = uAncestors.add(v);
                if (vAncestors == uAncestors || visitedCount.merge(v, 1, Integer::sum) != 1) continue;
                queue.add(new VertexBackLinkWithAncestorSet<V>(v, u, vAncestors));
            }
        }
        for (VertexBackLinkWithAncestorSet node = found; node != null; node = (VertexBackLinkWithAncestorSet)node.getParent()) {
            if ((Integer)visitedCount.get(node.getVertex()) <= 1) continue;
            return new SimpleOrderedPair((Object)SearchResultType.FAILURE_NOT_UNIQUE, null);
        }
        return found == null ? new SimpleOrderedPair((Object)SearchResultType.FAILURE_NO_PATH, null) : new SimpleOrderedPair((Object)SearchResultType.SUCCESS_UNIQUE_PATH, (Object)found);
    }

    private static enum SearchResultType {
        SUCCESS_UNIQUE_PATH,
        FAILURE_NO_PATH,
        FAILURE_NOT_UNIQUE;

    }
}

