/*
 * Decompiled with CFR 0.152.
 */
package org.jhotdraw8.graph.path.backlink;

import java.util.ArrayDeque;
import java.util.function.BiFunction;
import org.jhotdraw8.base.function.Function3;
import org.jhotdraw8.graph.path.backlink.AbstractBackLink;
import org.jhotdraw8.graph.path.backlink.ArcBackLinkWithCost;
import org.jspecify.annotations.Nullable;

public class ArcBackLink<V, A>
extends AbstractBackLink<ArcBackLink<V, A>> {
    private final V vertex;
    private final @Nullable A arrow;

    public ArcBackLink(V vertex, @Nullable A arrow, @Nullable ArcBackLink<V, A> parent) {
        super(parent);
        this.vertex = vertex;
        this.arrow = arrow;
    }

    public @Nullable A getArrow() {
        return this.arrow;
    }

    public V getVertex() {
        return this.vertex;
    }

    public String toString() {
        return "ArcBackLink{depth=" + this.depth + ", vertex=" + String.valueOf(this.vertex) + ", arrow=" + String.valueOf(this.arrow) + "}";
    }

    public static <VV, AA, CC extends Number> @Nullable ArcBackLinkWithCost<VV, AA, CC> toArcBackLinkWithCost(@Nullable ArcBackLink<VV, AA> node, CC zero, Function3<VV, VV, AA, CC> costFunction, BiFunction<CC, CC, CC> sumFunction) {
        if (node == null) {
            return null;
        }
        ArrayDeque<ArcBackLink> deque = new ArrayDeque<ArcBackLink>();
        for (ArcBackLink n = node; n != null; n = (ArcBackLink)n.getParent()) {
            deque.addFirst(n);
        }
        ArcBackLinkWithCost newNode = null;
        for (ArcBackLink n : deque) {
            newNode = new ArcBackLinkWithCost(n.getVertex(), n.getArrow(), newNode, newNode == null ? zero : (Number)sumFunction.apply(newNode.getCost(), (Number)costFunction.apply(newNode.getVertex(), n.getVertex(), n.getArrow())));
        }
        return newNode;
    }
}

