/*
 * Decompiled with CFR 0.152.
 */
package org.jhotdraw8.graph.path.backlink;

import java.util.ArrayDeque;
import java.util.function.BiFunction;
import org.jhotdraw8.base.function.Function3;
import org.jhotdraw8.graph.path.backlink.AbstractBackLink;
import org.jhotdraw8.graph.path.backlink.ArcBackLinkWithCost;
import org.jhotdraw8.icollection.ChampAddOnlySet;
import org.jspecify.annotations.Nullable;

public class ArcBackLinkWithAncestorSet<V, A>
extends AbstractBackLink<ArcBackLinkWithAncestorSet<V, A>> {
    private final V vertex;
    private final @Nullable A arrow;
    private @Nullable ChampAddOnlySet<V> ancestors;

    public ArcBackLinkWithAncestorSet(V vertex, @Nullable A arrow, @Nullable ArcBackLinkWithAncestorSet<V, A> parent, ChampAddOnlySet<V> ancestors) {
        super(parent);
        this.vertex = vertex;
        this.arrow = arrow;
        this.ancestors = ancestors;
    }

    public static <VV, AA, CC extends Number> @Nullable ArcBackLinkWithCost<VV, AA, CC> toArcBackLinkWithCost(@Nullable ArcBackLinkWithAncestorSet<VV, AA> node, CC zero, Function3<VV, VV, AA, CC> costFunction, BiFunction<CC, CC, CC> sumFunction) {
        if (node == null) {
            return null;
        }
        ArrayDeque<ArcBackLinkWithAncestorSet> deque = new ArrayDeque<ArcBackLinkWithAncestorSet>();
        for (ArcBackLinkWithAncestorSet n = node; n != null; n = (ArcBackLinkWithAncestorSet)n.getParent()) {
            deque.addFirst(n);
        }
        ArcBackLinkWithCost newNode = null;
        for (ArcBackLinkWithAncestorSet n : deque) {
            newNode = new ArcBackLinkWithCost(n.getVertex(), n.getArrow(), newNode, newNode == null ? zero : (Number)sumFunction.apply(newNode.getCost(), (Number)costFunction.apply(newNode.getVertex(), n.getVertex(), n.getArrow())));
        }
        return newNode;
    }

    public ChampAddOnlySet<V> removeAncestors() {
        if (this.ancestors == null) {
            throw new IllegalStateException("ancestors already removed");
        }
        ChampAddOnlySet<V> ancestors = this.ancestors;
        this.ancestors = null;
        return ancestors;
    }

    public @Nullable A getArrow() {
        return this.arrow;
    }

    public V getVertex() {
        return this.vertex;
    }

    public String toString() {
        return "ArcBackLink{depth=" + this.depth + ", vertex=" + String.valueOf(this.vertex) + ", arrow=" + String.valueOf(this.arrow) + "}";
    }
}

