/*
 * Decompiled with CFR 0.152.
 */
package org.jhotdraw8.graph.path.backlink;

import java.util.ArrayDeque;
import java.util.function.BiFunction;
import org.jhotdraw8.graph.path.backlink.AbstractBackLink;
import org.jhotdraw8.graph.path.backlink.IndexedVertexBackLinkWithCost;
import org.jspecify.annotations.Nullable;

public class IndexedVertexBackLink
extends AbstractBackLink<IndexedVertexBackLink> {
    final int vertex;

    public IndexedVertexBackLink(int vertex, @Nullable IndexedVertexBackLink parent) {
        super(parent);
        this.vertex = vertex;
    }

    public int getVertex() {
        return this.vertex;
    }

    public static <CC extends Number> @Nullable IndexedVertexBackLinkWithCost<CC> toIndexedVertexBackLinkWithCost(@Nullable IndexedVertexBackLink node, CC zero, BiFunction<Integer, Integer, CC> costFunction, BiFunction<CC, CC, CC> sumFunction) {
        if (node == null) {
            return null;
        }
        ArrayDeque<IndexedVertexBackLink> deque = new ArrayDeque<IndexedVertexBackLink>();
        for (IndexedVertexBackLink n = node; n != null; n = (IndexedVertexBackLink)n.getParent()) {
            deque.addFirst(n);
        }
        IndexedVertexBackLinkWithCost<CC> newNode = null;
        for (IndexedVertexBackLink n : deque) {
            newNode = new IndexedVertexBackLinkWithCost<CC>(n.getVertex(), newNode, newNode == null ? zero : (Number)sumFunction.apply(newNode.getCost(), (Number)costFunction.apply(newNode.getVertex(), n.getVertex())));
        }
        return newNode;
    }
}

