/*
 * Decompiled with CFR 0.152.
 */
package org.jhotdraw8.graph.path.backlink;

import java.util.ArrayDeque;
import java.util.function.Function;
import org.jhotdraw8.collection.pair.SimpleOrderedPair;
import org.jhotdraw8.graph.path.backlink.AbstractBackLinkWithCost;
import org.jhotdraw8.icollection.VectorList;
import org.jhotdraw8.icollection.immutable.ImmutableList;
import org.jspecify.annotations.Nullable;

public class VertexBackLinkWithCost<V, C extends Number>
extends AbstractBackLinkWithCost<VertexBackLinkWithCost<V, C>, C> {
    private final V vertex;

    public VertexBackLinkWithCost(V vertex, @Nullable VertexBackLinkWithCost<V, C> parent, C cost) {
        super(parent, cost);
        this.vertex = vertex;
    }

    public V getVertex() {
        return this.vertex;
    }

    public static <VV, CC extends Number, XX> @Nullable SimpleOrderedPair<ImmutableList<XX>, CC> toVertexSequence(@Nullable VertexBackLinkWithCost<VV, CC> node, Function<VertexBackLinkWithCost<VV, CC>, XX> mappingFunction) {
        if (node == null) {
            return null;
        }
        ArrayDeque<XX> deque = new ArrayDeque<XX>();
        for (VertexBackLinkWithCost parent = node; parent != null; parent = (VertexBackLinkWithCost)parent.getParent()) {
            deque.addFirst(mappingFunction.apply(parent));
        }
        return new SimpleOrderedPair((Object)VectorList.copyOf(deque), node.getCost());
    }
}

