/*
 * Decompiled with CFR 0.152.
 */
package org.jhotdraw8.icollection;

import java.io.ObjectStreamException;
import java.io.Serializable;
import java.util.AbstractMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Objects;
import java.util.Random;
import java.util.Spliterator;
import org.jhotdraw8.annotation.NonNull;
import org.jhotdraw8.annotation.Nullable;
import org.jhotdraw8.icollection.MutableChampMap;
import org.jhotdraw8.icollection.PrivateData;
import org.jhotdraw8.icollection.facade.ReadOnlySetFacade;
import org.jhotdraw8.icollection.immutable.ImmutableMap;
import org.jhotdraw8.icollection.impl.IdentityObject;
import org.jhotdraw8.icollection.impl.champmap.AbstractMutableChampMap;
import org.jhotdraw8.icollection.impl.champmap.BitmapIndexedNode;
import org.jhotdraw8.icollection.impl.champmap.ChangeEvent;
import org.jhotdraw8.icollection.impl.champmap.EntryIterator;
import org.jhotdraw8.icollection.impl.champmap.Node;
import org.jhotdraw8.icollection.impl.iteration.IteratorSpliterator;
import org.jhotdraw8.icollection.impl.iteration.MappedIterator;
import org.jhotdraw8.icollection.readonly.ReadOnlyMap;
import org.jhotdraw8.icollection.readonly.ReadOnlySet;
import org.jhotdraw8.icollection.serialization.MapSerializationProxy;

public class ChampMap<K, V>
implements ImmutableMap<K, V>,
Serializable {
    private static final @NonNull ChampMap<?, ?> EMPTY = new ChampMap(BitmapIndexedNode.emptyNode(), 0);
    private static final long serialVersionUID = 0L;
    static final int SALT = new Random().nextInt();
    final @NonNull BitmapIndexedNode<K, V> root;
    final int size;

    protected ChampMap(@NonNull PrivateData privateData) {
        this((BitmapIndexedNode)((Map.Entry)privateData.get()).getKey(), (Integer)((Map.Entry)privateData.get()).getValue());
    }

    protected @NonNull ChampMap<K, V> newInstance(@NonNull PrivateData privateData) {
        return new ChampMap<K, V>(privateData);
    }

    private @NonNull ChampMap<K, V> newInstance(@NonNull BitmapIndexedNode<K, V> root, int size) {
        return this.newInstance(new PrivateData(new AbstractMap.SimpleImmutableEntry<BitmapIndexedNode<K, V>, Integer>(root, size)));
    }

    ChampMap(@NonNull BitmapIndexedNode<K, V> root, int size) {
        this.root = root;
        this.size = size;
    }

    @Override
    public int characteristics() {
        return 1089;
    }

    public static <K, V> @NonNull ChampMap<K, V> copyOf(@NonNull Iterable<? extends Map.Entry<? extends K, ? extends V>> c) {
        return ChampMap.of().putAll(c);
    }

    public static <K, V> @NonNull ChampMap<K, V> copyOf(@NonNull Map<? extends K, ? extends V> map) {
        return ChampMap.of().putAll((Map)map);
    }

    static <V, K> boolean entryKeyEquals(AbstractMap.SimpleImmutableEntry<K, V> a, AbstractMap.SimpleImmutableEntry<K, V> b) {
        return Objects.equals(a.getKey(), b.getKey());
    }

    static <V, K> int keyHash(Object e) {
        return SALT ^ Objects.hashCode(e);
    }

    static <V, K> int entryKeyHash(AbstractMap.SimpleImmutableEntry<K, V> e) {
        return SALT ^ ChampMap.keyHash(e.getKey());
    }

    public static <K, V> @NonNull ChampMap<K, V> of() {
        return EMPTY;
    }

    @Override
    public @NonNull ChampMap<K, V> clear() {
        return this.isEmpty() ? this : ChampMap.of();
    }

    @Override
    public boolean containsKey(@Nullable Object o) {
        Object key = o;
        return this.root.findByKey(key, ChampMap.keyHash(key), 0) != Node.NO_DATA;
    }

    @Override
    public boolean equals(@Nullable Object other) {
        if (other == this) {
            return true;
        }
        if (other instanceof ChampMap) {
            ChampMap that = (ChampMap)other;
            return this.size == that.size && this.root.equivalent(that.root);
        }
        return ReadOnlyMap.mapEquals(this, other);
    }

    @Override
    public @Nullable V get(Object o) {
        Object result = this.root.findByKey(o, ChampMap.keyHash(o), 0);
        return (V)(result == Node.NO_DATA ? null : result);
    }

    static <K, V>  @Nullable AbstractMap.SimpleImmutableEntry<K, V> updateEntry( @Nullable AbstractMap.SimpleImmutableEntry<K, V> oldv,  @Nullable AbstractMap.SimpleImmutableEntry<K, V> newv) {
        return Objects.equals(oldv.getValue(), newv.getValue()) ? oldv : newv;
    }

    @Override
    public int hashCode() {
        return ReadOnlyMap.iteratorToHashCode(this.iterator());
    }

    @Override
    public boolean isEmpty() {
        return this.size == 0;
    }

    @Override
    public @NonNull Iterator<Map.Entry<K, V>> iterator() {
        return new EntryIterator<K, V>(this.root, null, null);
    }

    @Override
    public int maxSize() {
        return Integer.MAX_VALUE;
    }

    @Override
    public @NonNull ChampMap<K, V> put(@NonNull K key, @Nullable V value) {
        ChangeEvent details = new ChangeEvent();
        Node newRootNode = this.root.put((IdentityObject)null, (Object)key, (Object)value, ChampMap.keyHash(key), 0, details, ChampMap::keyHash);
        if (details.isModified()) {
            return this.newInstance((BitmapIndexedNode<K, V>)newRootNode, details.isReplaced() ? this.size : this.size + 1);
        }
        return this;
    }

    @Override
    public @NonNull ChampMap<K, V> putAll(@NonNull Map<? extends K, ? extends V> m) {
        return (ChampMap)ImmutableMap.super.putAll(m);
    }

    @Override
    public @NonNull ChampMap<K, V> putAll(@NonNull Iterable<? extends Map.Entry<? extends K, ? extends V>> c) {
        Map m = this.toMutable();
        return ((AbstractMutableChampMap)m).putAll(c) ? ((MutableChampMap)m).toImmutable() : this;
    }

    @Override
    public @NonNull ChampMap<K, V> remove(@NonNull K key) {
        int keyHash = ChampMap.keyHash(key);
        ChangeEvent details = new ChangeEvent();
        Node newRootNode = this.root.remove((IdentityObject)null, (Object)key, keyHash, 0, details);
        if (details.isModified()) {
            return this.size == 1 ? ChampMap.of() : this.newInstance((BitmapIndexedNode<K, V>)newRootNode, this.size - 1);
        }
        return this;
    }

    @Override
    public @NonNull ChampMap<K, V> removeAll(@NonNull Iterable<? extends K> c) {
        Map m = this.toMutable();
        return ((MutableChampMap)m).removeAll(c) ? ((MutableChampMap)m).toImmutable() : this;
    }

    @Override
    public @NonNull ChampMap<K, V> retainAll(@NonNull Iterable<? extends K> c) {
        Map m = this.toMutable();
        return ((AbstractMutableChampMap)m).retainAll(c) ? ((MutableChampMap)m).toImmutable() : this;
    }

    @Override
    public @NonNull ReadOnlySet<K> readOnlyKeySet() {
        return new ReadOnlySetFacade(() -> new MappedIterator<Object, Map.Entry>(new EntryIterator<K, V>(this.root, null, null), Map.Entry::getKey), this::size, this::containsKey, 1024);
    }

    @Override
    public int size() {
        return this.size;
    }

    @Override
    public @NonNull Spliterator<Map.Entry<K, V>> spliterator() {
        return new IteratorSpliterator<Map.Entry<K, V>>(this.iterator(), this.size(), this.characteristics(), null);
    }

    @Override
    public @NonNull MutableChampMap<K, V> toMutable() {
        return new MutableChampMap(this);
    }

    @Override
    public @NonNull MutableChampMap<K, V> asMap() {
        return new MutableChampMap(this);
    }

    public @NonNull String toString() {
        return ReadOnlyMap.mapToString(this);
    }

    private @NonNull Object writeReplace() throws ObjectStreamException {
        return new SerializationProxy(this.toMutable());
    }

    static class SerializationProxy<K, V>
    extends MapSerializationProxy<K, V> {
        private static final long serialVersionUID = 0L;

        SerializationProxy(Map<K, V> target) {
            super(target);
        }

        @Override
        protected @NonNull Object readResolve() {
            return ChampMap.of().putAll((Iterable)this.deserializedEntries);
        }
    }
}

