/*
 * Decompiled with CFR 0.152.
 */
package org.jhotdraw8.icollection;

import java.io.Serializable;
import java.util.AbstractMap;
import java.util.Arrays;
import java.util.Iterator;
import java.util.Map;
import java.util.Objects;
import java.util.Random;
import java.util.Set;
import java.util.Spliterator;
import org.jhotdraw8.annotation.NonNull;
import org.jhotdraw8.annotation.Nullable;
import org.jhotdraw8.icollection.MutableChampSet;
import org.jhotdraw8.icollection.PrivateData;
import org.jhotdraw8.icollection.immutable.ImmutableSet;
import org.jhotdraw8.icollection.impl.IdentityObject;
import org.jhotdraw8.icollection.impl.champ.BitmapIndexedNode;
import org.jhotdraw8.icollection.impl.champ.ChampIterator;
import org.jhotdraw8.icollection.impl.champ.ChampSpliterator;
import org.jhotdraw8.icollection.impl.champ.ChangeEvent;
import org.jhotdraw8.icollection.impl.champ.Node;
import org.jhotdraw8.icollection.readonly.ReadOnlyCollection;
import org.jhotdraw8.icollection.readonly.ReadOnlySet;
import org.jhotdraw8.icollection.serialization.SetSerializationProxy;

public class ChampSet<E>
implements ImmutableSet<E>,
Serializable {
    static final int SALT = new Random().nextInt();
    private static final @NonNull ChampSet<?> EMPTY = new ChampSet(BitmapIndexedNode.emptyNode(), 0);
    private static final long serialVersionUID = 0L;
    final @NonNull BitmapIndexedNode<E> root;
    final int size;

    protected ChampSet(@NonNull PrivateData privateData) {
        this((BitmapIndexedNode)((Map.Entry)privateData.get()).getKey(), (Integer)((Map.Entry)privateData.get()).getValue());
    }

    protected @NonNull ChampSet<E> newInstance(@NonNull PrivateData privateData) {
        return new ChampSet<E>(privateData);
    }

    private @NonNull ChampSet<E> newInstance(@NonNull BitmapIndexedNode<E> root, int size) {
        return new ChampSet<E>(new PrivateData(new AbstractMap.SimpleImmutableEntry<BitmapIndexedNode<E>, Integer>(root, size)));
    }

    ChampSet(@NonNull BitmapIndexedNode<E> root, int size) {
        this.root = root;
        this.size = size;
    }

    public static <E> @NonNull ChampSet<E> copyOf(@NonNull Iterable<? extends E> c) {
        return ChampSet.of().addAll(c);
    }

    public static <E> @NonNull ChampSet<E> of() {
        return EMPTY;
    }

    public static <T> ChampSet<T> ofIterator(Iterator<T> iterator) {
        return ChampSet.of().addAll(() -> iterator);
    }

    @SafeVarargs
    public static <E> @NonNull ChampSet<E> of(E ... elements) {
        Objects.requireNonNull(elements, "elements is null");
        return ChampSet.of().addAll((Iterable)Arrays.asList(elements));
    }

    static <E> E updateElement(E oldElement, E newElement) {
        return oldElement;
    }

    static int keyHash(Object e) {
        return SALT ^ Objects.hashCode(e);
    }

    @Override
    public @NonNull ChampSet<E> add(@Nullable E element) {
        int keyHash = ChampSet.keyHash(element);
        ChangeEvent details = new ChangeEvent();
        Node newRootNode = this.root.put((IdentityObject)null, (Object)element, keyHash, 0, details, ChampSet::updateElement, Objects::equals, ChampSet::keyHash);
        if (details.isModified()) {
            return this.newInstance((BitmapIndexedNode<E>)newRootNode, this.size + 1);
        }
        return this;
    }

    @Override
    public @NonNull ChampSet<E> addAll(@NonNull Iterable<? extends E> c) {
        Set m = this.toMutable();
        return ((MutableChampSet)m).addAll(c) ? ((MutableChampSet)m).toImmutable() : this;
    }

    @Override
    public <T> @NonNull ChampSet<T> empty() {
        return ChampSet.of();
    }

    @Override
    public boolean contains(@Nullable Object o) {
        return this.root.find(o, ChampSet.keyHash(o), 0, Objects::equals) != Node.NO_DATA;
    }

    @Override
    public boolean equals(@Nullable Object other) {
        if (other == this) {
            return true;
        }
        if (other == null) {
            return false;
        }
        if (other instanceof ChampSet) {
            ChampSet that = (ChampSet)other;
            return this.size == that.size && this.root.equivalent(that.root);
        }
        return ReadOnlySet.setEquals(this, other);
    }

    @Override
    public int hashCode() {
        return ReadOnlySet.iteratorToHashCode(this.iterator());
    }

    @Override
    public @NonNull Iterator<E> iterator() {
        return new ChampIterator(this.root, null);
    }

    @Override
    public int maxSize() {
        return Integer.MAX_VALUE;
    }

    @Override
    public @NonNull ChampSet<E> remove(@NonNull E key) {
        int keyHash = ChampSet.keyHash(key);
        ChangeEvent details = new ChangeEvent();
        Node newRootNode = this.root.remove((IdentityObject)null, (Object)key, keyHash, 0, details, Objects::equals);
        if (details.isModified()) {
            return this.size == 1 ? ChampSet.of() : this.newInstance((BitmapIndexedNode<E>)newRootNode, this.size - 1);
        }
        return this;
    }

    @Override
    public @NonNull ChampSet<E> removeAll(@NonNull Iterable<?> c) {
        Set m = this.toMutable();
        return ((MutableChampSet)m).removeAll(c) ? ((MutableChampSet)m).toImmutable() : this;
    }

    @Override
    public @NonNull ChampSet<E> retainAll(@NonNull Iterable<?> c) {
        Set m = this.toMutable();
        return ((MutableChampSet)m).retainAll(c) ? ((MutableChampSet)m).toImmutable() : this;
    }

    @Override
    public int size() {
        return this.size;
    }

    @Override
    public @NonNull Spliterator<E> spliterator() {
        return new ChampSpliterator(this.root, null, this.size, 1089);
    }

    @Override
    public @NonNull MutableChampSet<E> toMutable() {
        return new MutableChampSet(this);
    }

    public @NonNull String toString() {
        return ReadOnlyCollection.iterableToString(this);
    }

    private @NonNull Object writeReplace() {
        return new SerializationProxy(this.toMutable());
    }

    private static class SerializationProxy<E>
    extends SetSerializationProxy<E> {
        private static final long serialVersionUID = 0L;

        protected SerializationProxy(@NonNull Set<E> target) {
            super(target);
        }

        @Override
        protected @NonNull Object readResolve() {
            return ChampSet.copyOf(this.deserializedElements);
        }
    }
}

