/*
 * Decompiled with CFR 0.152.
 */
package org.jhotdraw8.icollection;

import java.lang.runtime.SwitchBootstraps;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Objects;
import java.util.Set;
import java.util.Spliterator;
import java.util.function.Function;
import org.jhotdraw8.annotation.NonNull;
import org.jhotdraw8.annotation.Nullable;
import org.jhotdraw8.icollection.ChampSet;
import org.jhotdraw8.icollection.impl.champ.AbstractMutableChampSet;
import org.jhotdraw8.icollection.impl.champ.BitmapIndexedNode;
import org.jhotdraw8.icollection.impl.champ.BulkChangeEvent;
import org.jhotdraw8.icollection.impl.champ.ChampIterator;
import org.jhotdraw8.icollection.impl.champ.ChampSpliterator;
import org.jhotdraw8.icollection.impl.champ.ChangeEvent;
import org.jhotdraw8.icollection.impl.champ.Node;
import org.jhotdraw8.icollection.impl.iteration.FailFastIterator;
import org.jhotdraw8.icollection.impl.iteration.FailFastSpliterator;
import org.jhotdraw8.icollection.readonly.ReadOnlyCollection;
import org.jhotdraw8.icollection.serialization.SetSerializationProxy;

public class MutableChampSet<E>
extends AbstractMutableChampSet<E, E> {
    private static final long serialVersionUID = 0L;

    public MutableChampSet() {
        this.root = BitmapIndexedNode.emptyNode();
    }

    public MutableChampSet(@NonNull Iterable<? extends E> c) {
        if (c instanceof MutableChampSet) {
            c = ((MutableChampSet)c).toImmutable();
        }
        if (c instanceof ChampSet) {
            ChampSet that = (ChampSet)c;
            this.root = that.root;
            this.size = that.size;
        } else {
            this.root = BitmapIndexedNode.emptyNode();
            this.addAll(c);
        }
    }

    @Override
    public boolean add(@Nullable E e) {
        ChangeEvent details = new ChangeEvent();
        this.root = this.root.put(this.makeOwner(), e, ChampSet.keyHash(e), 0, details, (oldKey, newKey) -> oldKey, Objects::equals, ChampSet::keyHash);
        if (details.isModified()) {
            ++this.size;
            ++this.modCount;
        }
        return details.isModified();
    }

    @Override
    public boolean addAll(@NonNull Iterable<? extends E> c) {
        if (c instanceof MutableChampSet) {
            MutableChampSet m = (MutableChampSet)c;
            c = m.toImmutable();
        }
        if (this.isEmpty() && c instanceof ChampSet) {
            ChampSet cc = (ChampSet)c;
            this.root = cc.root;
            this.size = cc.size;
            return true;
        }
        if (c instanceof ChampSet) {
            ChampSet that = (ChampSet)c;
            BulkChangeEvent bulkChange = new BulkChangeEvent();
            Node newRootNode = this.root.putAll(this.makeOwner(), (Node)that.root, 0, bulkChange, ChampSet::updateElement, Objects::equals, ChampSet::keyHash, new ChangeEvent());
            if (bulkChange.inBoth == that.size()) {
                return false;
            }
            this.root = newRootNode;
            this.size += that.size - bulkChange.inBoth;
            ++this.modCount;
            return true;
        }
        return super.addAll(c);
    }

    @Override
    public boolean removeAll(@NonNull Collection<?> c) {
        return this.removeAll((Iterable<?>)c);
    }

    @Override
    public boolean removeAll(@NonNull Iterable<?> c) {
        ReadOnlyCollection rc;
        Collection cc;
        if (this.isEmpty() || c instanceof Collection && (cc = (Collection)c).isEmpty() || c instanceof ReadOnlyCollection && (rc = (ReadOnlyCollection)c).isEmpty()) {
            return false;
        }
        if (c == this) {
            this.clear();
            return true;
        }
        if (c instanceof MutableChampSet) {
            MutableChampSet m = (MutableChampSet)c;
            c = m.toImmutable();
        }
        if (c instanceof ChampSet) {
            ChampSet that = (ChampSet)c;
            BulkChangeEvent bulkChange = new BulkChangeEvent();
            Node newRootNode = this.root.removeAll(this.makeOwner(), (Node)that.root, 0, bulkChange, ChampSet::updateElement, Objects::equals, ChampSet::keyHash, new ChangeEvent());
            if (bulkChange.removed == 0) {
                return false;
            }
            this.root = newRootNode;
            this.size -= bulkChange.removed;
            ++this.modCount;
            return true;
        }
        return super.removeAll(c);
    }

    @Override
    public boolean retainAll(@NonNull Collection<?> c) {
        if (this.isEmpty()) {
            return false;
        }
        if (c.isEmpty()) {
            this.clear();
            return true;
        }
        if (c instanceof MutableChampSet) {
            MutableChampSet m = (MutableChampSet)c;
            ChampSet<E> that = m.toImmutable();
            BulkChangeEvent bulkChange = new BulkChangeEvent();
            Node newRootNode = this.root.retainAll(this.makeOwner(), (Node)that.root, 0, bulkChange, ChampSet::updateElement, Objects::equals, ChampSet::keyHash, new ChangeEvent());
            if (bulkChange.removed == 0) {
                return false;
            }
            this.root = newRootNode;
            this.size -= bulkChange.removed;
            ++this.modCount;
            return true;
        }
        return super.retainAll(c);
    }

    @Override
    public boolean retainAll(@NonNull Iterable<?> c) {
        ReadOnlyCollection rc;
        Collection cc;
        if (c == this || this.isEmpty()) {
            return false;
        }
        if (c instanceof Collection && (cc = (Collection)c).isEmpty() || c instanceof ReadOnlyCollection && (rc = (ReadOnlyCollection)c).isEmpty()) {
            this.clear();
            return true;
        }
        BulkChangeEvent bulkChange = new BulkChangeEvent();
        Iterable<?> iterable = c;
        Objects.requireNonNull(iterable);
        Iterable<?> iterable2 = iterable;
        int n = 0;
        Node newRootNode = switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{ChampSet.class, Collection.class, ReadOnlyCollection.class}, iterable2, n)) {
            case 0 -> {
                ChampSet that = (ChampSet)iterable2;
                yield this.root.retainAll(this.makeOwner(), (Node)that.root, 0, bulkChange, ChampSet::updateElement, Objects::equals, ChampSet::keyHash, new ChangeEvent());
            }
            case 1 -> {
                Collection that = (Collection)iterable2;
                yield this.root.filterAll(this.makeOwner(), that::contains, 0, bulkChange);
            }
            case 2 -> {
                ReadOnlyCollection that = (ReadOnlyCollection)iterable2;
                yield this.root.filterAll(this.makeOwner(), that::contains, 0, bulkChange);
            }
            default -> {
                HashSet that = new HashSet();
                c.forEach(that::add);
                yield this.root.filterAll(this.makeOwner(), that::contains, 0, bulkChange);
            }
        };
        if (bulkChange.removed == 0) {
            return false;
        }
        this.root = newRootNode;
        this.size -= bulkChange.removed;
        ++this.modCount;
        return true;
    }

    @Override
    public void clear() {
        this.root = BitmapIndexedNode.emptyNode();
        this.size = 0;
        ++this.modCount;
    }

    @Override
    public @NonNull MutableChampSet<E> clone() {
        return (MutableChampSet)super.clone();
    }

    @Override
    public boolean contains(@Nullable Object o) {
        return Node.NO_DATA != this.root.find(o, ChampSet.keyHash(o), 0, Objects::equals);
    }

    @Override
    public @NonNull Iterator<E> iterator() {
        return new FailFastIterator<Object>(new ChampIterator(this.root, null), this::iteratorRemove, () -> this.getModCount());
    }

    @Override
    public Spliterator<E> spliterator() {
        return new FailFastSpliterator(new ChampSpliterator(this.root, Function.identity(), this.size, 65), () -> this.modCount, null);
    }

    private void iteratorRemove(E e) {
        this.owner = null;
        this.remove(e);
    }

    @Override
    public boolean remove(Object o) {
        ChangeEvent details = new ChangeEvent();
        this.root = this.root.remove(this.makeOwner(), o, ChampSet.keyHash(o), 0, details, Objects::equals);
        if (details.isModified()) {
            --this.size;
            ++this.modCount;
        }
        return details.isModified();
    }

    public @NonNull ChampSet<E> toImmutable() {
        this.owner = null;
        return this.size == 0 ? ChampSet.of() : new ChampSet(this.root, this.size);
    }

    private @NonNull Object writeReplace() {
        return new SerializationProxy(this);
    }

    private static class SerializationProxy<E>
    extends SetSerializationProxy<E> {
        private static final long serialVersionUID = 0L;

        protected SerializationProxy(@NonNull Set<E> target) {
            super(target);
        }

        @Override
        protected @NonNull Object readResolve() {
            return new MutableChampSet(this.deserializedElements);
        }
    }
}

