/*
 * Decompiled with CFR 0.152.
 */
package org.jhotdraw8.icollection;

import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import java.util.SequencedCollection;
import java.util.SequencedMap;
import java.util.SequencedSet;
import java.util.Set;
import java.util.Spliterator;
import java.util.Spliterators;
import org.jhotdraw8.annotation.NonNull;
import org.jhotdraw8.annotation.Nullable;
import org.jhotdraw8.icollection.ChampVectorMap;
import org.jhotdraw8.icollection.MutableMapEntry;
import org.jhotdraw8.icollection.VectorList;
import org.jhotdraw8.icollection.facade.ReadOnlySequencedMapFacade;
import org.jhotdraw8.icollection.facade.SequencedMapFacade;
import org.jhotdraw8.icollection.facade.SequencedSetFacade;
import org.jhotdraw8.icollection.impl.champ.AbstractMutableChampMap;
import org.jhotdraw8.icollection.impl.champ.BitmapIndexedNode;
import org.jhotdraw8.icollection.impl.champ.ChangeEvent;
import org.jhotdraw8.icollection.impl.champ.Node;
import org.jhotdraw8.icollection.impl.champ.OrderedPair;
import org.jhotdraw8.icollection.impl.champ.ReverseTombSkippingVectorSpliterator;
import org.jhotdraw8.icollection.impl.champ.SequencedData;
import org.jhotdraw8.icollection.impl.champ.SequencedEntry;
import org.jhotdraw8.icollection.impl.champ.TombSkippingVectorSpliterator;
import org.jhotdraw8.icollection.impl.iteration.FailFastIterator;
import org.jhotdraw8.icollection.readonly.ReadOnlySequencedMap;
import org.jhotdraw8.icollection.sequenced.ReversedSequencedMapView;
import org.jhotdraw8.icollection.serialization.MapSerializationProxy;

public class MutableChampVectorMap<K, V>
extends AbstractMutableChampMap<K, V, SequencedEntry<K, V>>
implements SequencedMap<K, V>,
ReadOnlySequencedMap<K, V> {
    private static final long serialVersionUID = 0L;
    private int offset;
    private @NonNull VectorList<Object> vector;

    public MutableChampVectorMap() {
        this.offset = 0;
        this.root = BitmapIndexedNode.emptyNode();
        this.vector = VectorList.of();
    }

    public MutableChampVectorMap(@NonNull Map<? extends K, ? extends V> c) {
        Iterable<Map.Entry<Object, Object>> iterable;
        if (c instanceof MutableChampVectorMap) {
            MutableChampVectorMap mvm = (MutableChampVectorMap)c;
            iterable = mvm.toImmutable();
        } else {
            iterable = c.entrySet();
        }
        this(iterable);
    }

    public MutableChampVectorMap(@NonNull Iterable<? extends Map.Entry<? extends K, ? extends V>> c) {
        this.offset = 0;
        if (c instanceof ChampVectorMap) {
            ChampVectorMap that = (ChampVectorMap)c;
            this.root = that.root;
            this.size = that.size;
            this.offset = that.offset;
            this.vector = that.vector;
        } else {
            this.root = BitmapIndexedNode.emptyNode();
            this.vector = VectorList.of();
            this.putAll(c);
        }
    }

    @Override
    public void clear() {
        this.root = BitmapIndexedNode.emptyNode();
        this.vector = VectorList.of();
        this.size = 0;
        ++this.modCount;
        this.offset = -1;
    }

    @Override
    public @NonNull MutableChampVectorMap<K, V> clone() {
        return (MutableChampVectorMap)super.clone();
    }

    @Override
    public boolean containsKey(@Nullable Object o) {
        return Node.NO_DATA != this.root.find(new SequencedEntry(o), SequencedEntry.keyHash(o), 0, SequencedEntry::keyEquals);
    }

    @Override
    public @NonNull Iterator<Map.Entry<K, V>> iterator() {
        return new FailFastIterator<Map.Entry<K, V>>(Spliterators.iterator(this.spliterator()), this::iteratorRemove, () -> this.modCount);
    }

    private @NonNull Iterator<Map.Entry<K, V>> reverseIterator() {
        return new FailFastIterator<Map.Entry<K, V>>(Spliterators.iterator(this.reverseSpliterator()), this::iteratorRemove, () -> this.modCount);
    }

    private @NonNull Spliterator<Map.Entry<K, V>> reverseSpliterator() {
        return new ReverseTombSkippingVectorSpliterator<Map.Entry<K, V>>(this.vector, e -> new MutableMapEntry<Object, Object>(this::iteratorPutIfPresent, ((SequencedEntry)e).getKey(), ((SequencedEntry)e).getValue()), this.size(), this.characteristics() | 0x100);
    }

    @Override
    public @NonNull Spliterator<Map.Entry<K, V>> spliterator() {
        return new TombSkippingVectorSpliterator<Map.Entry<K, V>>(this.vector.trie, e -> new MutableMapEntry<Object, Object>(this::iteratorPutIfPresent, ((SequencedEntry)e).getKey(), ((SequencedEntry)e).getValue()), 0, this.size(), this.vector.size(), this.characteristics() | 0x100);
    }

    @Override
    public @NonNull Set<Map.Entry<K, V>> entrySet() {
        return this.sequencedEntrySet();
    }

    @Override
    public @NonNull Set<K> keySet() {
        return this.sequencedKeySet();
    }

    @Override
    public @NonNull Collection<V> values() {
        return this.sequencedValues();
    }

    @Override
    public @NonNull SequencedSet<Map.Entry<K, V>> sequencedEntrySet() {
        return new SequencedSetFacade<Map.Entry<K, V>>(this::iterator, this::spliterator, this::reverseIterator, this::reverseSpliterator, this::size, this::containsEntry, this::clear, x$0 -> this.removeEntry(x$0), this::firstEntry, this::lastEntry, null, null, null, null);
    }

    @Override
    public @Nullable Map.Entry<K, V> firstEntry() {
        return this.isEmpty() ? null : (SequencedEntry)this.vector.getFirst();
    }

    @Override
    public @Nullable V get(Object o) {
        Object result = this.root.find(new SequencedEntry(o), SequencedEntry.keyHash(o), 0, SequencedEntry::keyEquals);
        return result instanceof SequencedEntry ? (V)((SequencedEntry)result).getValue() : null;
    }

    private void iteratorPutIfPresent(@NonNull K k, V v) {
        if (this.containsKey(k)) {
            this.owner = null;
            this.put(k, v);
        }
    }

    private void iteratorRemove(Map.Entry<K, V> entry) {
        this.owner = null;
        this.remove(entry.getKey());
    }

    @Override
    public @NonNull SequencedSet<K> sequencedKeySet() {
        return SequencedMapFacade.createKeySet(this);
    }

    @Override
    public @Nullable Map.Entry<K, V> lastEntry() {
        return this.isEmpty() ? null : (SequencedEntry)this.vector.getLast();
    }

    @Override
    public @Nullable Map.Entry<K, V> pollFirstEntry() {
        Map.Entry<K, V> e = this.firstEntry();
        if (e == null) {
            return null;
        }
        this.remove(e.getKey());
        return e;
    }

    @Override
    public @Nullable Map.Entry<K, V> pollLastEntry() {
        Map.Entry<K, V> e = this.lastEntry();
        if (e == null) {
            return null;
        }
        this.remove(e.getKey());
        return e;
    }

    @Override
    public @Nullable V put(K key, V value) {
        SequencedEntry<K, V> oldData = this.putLast(key, value, false).getOldData();
        return oldData == null ? null : (V)oldData.getValue();
    }

    @Override
    public @Nullable V putFirst(K key, V value) {
        SequencedEntry<K, V> oldData = this.putFirst(key, value, true).getOldData();
        return oldData == null ? null : (V)oldData.getValue();
    }

    private @NonNull ChangeEvent<SequencedEntry<K, V>> putFirst(K key, V val, boolean moveToFirst) {
        ChangeEvent<SequencedEntry<K, V>> details = new ChangeEvent<SequencedEntry<K, V>>();
        SequencedEntry<K, V> newEntry = new SequencedEntry<K, V>(key, val, -this.offset - 1);
        this.root = this.root.put(this.getOrCreateOwner(), newEntry, SequencedEntry.keyHash(key), 0, (ChangeEvent)details, moveToFirst ? SequencedEntry::updateAndMoveToFirst : SequencedEntry::update, SequencedEntry::keyEquals, SequencedEntry::entryKeyHash);
        if (details.isReplaced() && ((SequencedEntry)details.getOldDataNonNull()).getSequenceNumber() == details.getNewDataNonNull().getSequenceNumber()) {
            this.vector = this.vector.set(details.getNewDataNonNull().getSequenceNumber() - this.offset, (Object)details.getNewDataNonNull());
            return details;
        }
        if (details.isModified()) {
            if (details.isReplaced()) {
                if (moveToFirst) {
                    OrderedPair<VectorList<Object>, Integer> result = SequencedData.vecRemove(this.vector, details.getOldDataNonNull(), this.offset);
                    this.vector = result.first();
                }
            } else {
                ++this.modCount;
                ++this.size;
            }
            ++this.offset;
            this.vector = this.vector.addFirst((Object)newEntry);
            this.renumber();
        }
        return details;
    }

    @Override
    public boolean putAll(@NonNull Iterable<? extends Map.Entry<? extends K, ? extends V>> c) {
        ReadOnlySequencedMap<K, V> that;
        if (c instanceof MutableChampVectorMap) {
            that = (MutableChampVectorMap)c;
            c = ((MutableChampVectorMap)that).toImmutable();
        }
        if (this.isEmpty() && c instanceof ChampVectorMap) {
            that = (ChampVectorMap)c;
            if (((ChampVectorMap)that).isEmpty()) {
                return false;
            }
            this.root = ((ChampVectorMap)that).root;
            this.vector = ((ChampVectorMap)that).vector;
            this.offset = ((ChampVectorMap)that).offset;
            this.size = ((ChampVectorMap)that).size;
            ++this.modCount;
            return true;
        }
        return super.putAll(c);
    }

    @Override
    public @Nullable V putLast(K key, V value) {
        SequencedEntry<K, V> oldData = this.putLast(key, value, true).getOldData();
        return oldData == null ? null : (V)oldData.getValue();
    }

    @NonNull ChangeEvent<SequencedEntry<K, V>> putLast(K key, V value, boolean moveToLast) {
        ChangeEvent<SequencedEntry<K, V>> details = new ChangeEvent<SequencedEntry<K, V>>();
        SequencedEntry<K, V> newEntry = new SequencedEntry<K, V>(key, value, this.vector.size() - this.offset);
        this.root = this.root.put(this.getOrCreateOwner(), newEntry, SequencedEntry.keyHash(key), 0, (ChangeEvent)details, moveToLast ? SequencedEntry::updateAndMoveToLast : SequencedEntry::update, SequencedEntry::keyEquals, SequencedEntry::entryKeyHash);
        if (details.isReplaced() && ((SequencedEntry)details.getOldDataNonNull()).getSequenceNumber() == details.getNewDataNonNull().getSequenceNumber()) {
            this.vector = this.vector.set(details.getNewDataNonNull().getSequenceNumber() - this.offset, (Object)details.getNewDataNonNull());
            return details;
        }
        if (details.isModified()) {
            if (details.isReplaced()) {
                OrderedPair<VectorList<Object>, Integer> result = SequencedData.vecRemove(this.vector, details.getOldDataNonNull(), this.offset);
                this.vector = result.first();
                this.offset = result.second();
            } else {
                ++this.size;
            }
            ++this.modCount;
            this.vector = this.vector.add((Object)newEntry);
            this.renumber();
        }
        return details;
    }

    @Override
    public @NonNull ReadOnlySequencedMap<K, V> readOnlyReversed() {
        return new ReadOnlySequencedMapFacade<Object, Object>(this::iterator, this::reverseIterator, this::size, this::containsKey, this::get, this::lastEntry, this::firstEntry, 81, null);
    }

    @Override
    public @Nullable V remove(Object o) {
        Object key = o;
        ChangeEvent<SequencedEntry<Object, V>> details = this.removeAndGiveDetails(key);
        if (details.isModified()) {
            return details.getOldData().getValue();
        }
        return null;
    }

    @NonNull ChangeEvent<SequencedEntry<K, V>> removeAndGiveDetails(K key) {
        ChangeEvent<SequencedEntry<K, V>> details = new ChangeEvent<SequencedEntry<K, V>>();
        this.root = this.root.remove(this.getOrCreateOwner(), new SequencedEntry(key), SequencedEntry.keyHash(key), 0, (ChangeEvent)details, SequencedEntry::keyEquals);
        if (details.isModified()) {
            SequencedEntry oldElem = (SequencedEntry)details.getOldDataNonNull();
            OrderedPair<VectorList<Object>, Integer> result = SequencedData.vecRemove(this.vector, oldElem, this.offset);
            this.vector = result.first();
            this.offset = result.second();
            --this.size;
            ++this.modCount;
            this.renumber();
        }
        return details;
    }

    private void renumber() {
        if (SequencedData.vecMustRenumber(this.size, this.offset, this.vector.size())) {
            OrderedPair<BitmapIndexedNode<SequencedEntry>, VectorList<Object>> result = SequencedData.vecRenumber(this.getOrCreateOwner(), this.size, this.vector.size(), this.root, this.vector.trie, SequencedEntry::entryKeyHash, SequencedEntry::keyEquals, (e, seq) -> new SequencedEntry(e.getKey(), e.getValue(), (int)seq));
            this.root = result.first();
            this.vector = result.second();
            this.offset = 0;
        }
    }

    @Override
    public @NonNull SequencedMap<K, V> reversed() {
        return new ReversedSequencedMapView(this);
    }

    public @NonNull ChampVectorMap<K, V> toImmutable() {
        this.owner = null;
        return this.size == 0 ? ChampVectorMap.of() : new ChampVectorMap(this.root, this.vector, this.size, this.offset);
    }

    @Override
    public @NonNull SequencedCollection<V> sequencedValues() {
        return SequencedMapFacade.createValues(this);
    }

    private @NonNull Object writeReplace() {
        return new SerializationProxy(this);
    }

    private static class SerializationProxy<K, V>
    extends MapSerializationProxy<K, V> {
        private static final long serialVersionUID = 0L;

        protected SerializationProxy(Map<K, V> target) {
            super(target);
        }

        @Override
        protected @NonNull Object readResolve() {
            return new MutableChampVectorMap(this.deserializedEntries);
        }
    }
}

