/*
 * Decompiled with CFR 0.152.
 */
package org.jhotdraw8.icollection;

import java.io.Serializable;
import java.util.AbstractList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Spliterator;
import java.util.stream.Stream;
import org.jhotdraw8.annotation.NonNull;
import org.jhotdraw8.icollection.VectorList;
import org.jhotdraw8.icollection.facade.ReadOnlyListFacade;
import org.jhotdraw8.icollection.immutable.ImmutableList;
import org.jhotdraw8.icollection.impl.vector.BitMappedTrie;
import org.jhotdraw8.icollection.readonly.ReadOnlyList;
import org.jhotdraw8.icollection.readonly.ReadOnlySequencedCollection;
import org.jhotdraw8.icollection.sequenced.ReversedListView;
import org.jhotdraw8.icollection.serialization.ListSerializationProxy;

public class MutableVectorList<E>
extends AbstractList<E>
implements Serializable,
ReadOnlyList<E>,
List<E>,
Cloneable {
    private static final long serialVersionUID = 0L;
    private @NonNull BitMappedTrie<E> root;

    public MutableVectorList() {
        this.root = BitMappedTrie.empty();
    }

    @Override
    public void addFirst(E e) {
        this.root = this.root.prepend(Collections.singleton(e).iterator(), 1);
        ++this.modCount;
    }

    @Override
    public void addLast(E e) {
        this.root = this.root.append(e);
        ++this.modCount;
    }

    @Override
    public @NonNull ReadOnlySequencedCollection<E> readOnlyReversed() {
        return new ReadOnlyListFacade<Object>(this::size, index -> this.get(this.root.length - 1 - index), () -> this);
    }

    @Override
    public @NonNull List<E> reversed() {
        return new ReversedListView(this, this::modCount);
    }

    private int modCount() {
        return this.modCount;
    }

    @Override
    public int size() {
        return this.root.length;
    }

    @Override
    public E get(int index) {
        Objects.checkIndex(index, this.root.length);
        return this.root.get(index);
    }

    @Override
    public E getFirst() {
        return ReadOnlyList.super.getFirst();
    }

    @Override
    public E getLast() {
        return ReadOnlyList.super.getLast();
    }

    @Override
    public @NonNull ReadOnlyList<E> readOnlySubList(int fromIndex, int toIndex) {
        return new ReadOnlyListFacade<Object>(() -> toIndex - fromIndex, i -> this.get(i - fromIndex));
    }

    @Override
    public boolean addAll(int index, @NonNull Collection<? extends E> c) {
        Objects.checkIndex(index, this.root.length + 1);
        int oldSize = this.root.length;
        ImmutableList immutable = this.toImmutable().addAll(index, (Iterable)c);
        if (oldSize != ((VectorList)immutable).size()) {
            this.root = ((VectorList)immutable).trie;
            ++this.modCount;
            return true;
        }
        return false;
    }

    @Override
    public boolean addAll(int index, @NonNull Iterable<? extends E> c) {
        Objects.checkIndex(index, this.root.length + 1);
        int oldSize = this.root.length;
        ImmutableList immutable = this.toImmutable().addAll(index, c);
        if (oldSize != ((VectorList)immutable).size()) {
            this.root = ((VectorList)immutable).trie;
            ++this.modCount;
            return true;
        }
        return false;
    }

    @Override
    public boolean removeAll(@NonNull Collection<?> c) {
        int oldSize = this.root.length;
        ImmutableList immutable = this.toImmutable().removeAll(c);
        if (oldSize != ((VectorList)immutable).size()) {
            this.root = ((VectorList)immutable).trie;
            ++this.modCount;
            return true;
        }
        return false;
    }

    @Override
    public boolean retainAll(@NonNull Collection<?> c) {
        int oldSize = this.root.length;
        ImmutableList immutable = this.toImmutable().retainAll(c);
        if (oldSize != ((VectorList)immutable).size()) {
            this.root = ((VectorList)immutable).trie;
            ++this.modCount;
            return true;
        }
        return false;
    }

    public MutableVectorList(@NonNull Iterable<? extends E> c) {
        if (c instanceof MutableVectorList) {
            c = ((MutableVectorList)c).toImmutable();
        }
        if (c instanceof VectorList) {
            VectorList that = (VectorList)c;
            this.root = that.trie;
        } else {
            this.root = BitMappedTrie.empty();
            this.addAll(0, c);
        }
    }

    public @NonNull VectorList<E> toImmutable() {
        return this.root.length == 0 ? VectorList.of() : new VectorList<E>(this.root);
    }

    private @NonNull Object writeReplace() {
        return new SerializationProxy(this);
    }

    @Override
    public boolean add(E e) {
        this.root = this.root.append(e);
        ++this.modCount;
        return true;
    }

    @Override
    public E set(int index, E element) {
        Objects.checkIndex(index, this.root.length);
        E oldValue = this.get(index);
        this.root = this.root.update(index, element);
        return oldValue;
    }

    @Override
    public void add(int index, E element) {
        Objects.checkIndex(index, this.root.length + 1);
        if (index == this.root.length) {
            this.add(element);
        } else {
            this.addAll(index, (Collection<? extends E>)Collections.singleton(element));
        }
    }

    @Override
    public E remove(int index) {
        Objects.checkIndex(index, this.root.length);
        E removed = this.get(index);
        this.removeRange(index, index + 1);
        return removed;
    }

    @Override
    public @NonNull Spliterator<E> spliterator() {
        return this.root.spliterator(0, this.size(), 16464);
    }

    @Override
    public Stream<E> stream() {
        return super.stream();
    }

    @Override
    protected void removeRange(int fromIndex, int toIndex) {
        this.root = ((VectorList)this.toImmutable().removeRange((int)fromIndex, (int)toIndex)).trie;
        ++this.modCount;
    }

    public MutableVectorList<E> clone() {
        try {
            MutableVectorList clone = (MutableVectorList)super.clone();
            return clone;
        }
        catch (CloneNotSupportedException e) {
            throw new AssertionError();
        }
    }

    private static class SerializationProxy<E>
    extends ListSerializationProxy<E> {
        private static final long serialVersionUID = 0L;

        protected SerializationProxy(@NonNull List<E> target) {
            super(target);
        }

        @Override
        protected @NonNull Object readResolve() {
            return new MutableVectorList(this.deserializedElements);
        }
    }
}

