/*
 * Decompiled with CFR 0.152.
 */
package org.jhotdraw8.icollection.facade;

import java.util.Iterator;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import java.util.function.IntSupplier;
import java.util.function.Predicate;
import java.util.function.Supplier;
import org.jhotdraw8.annotation.NonNull;
import org.jhotdraw8.annotation.Nullable;
import org.jhotdraw8.icollection.readonly.ReadOnlyMap;

public class ReadOnlyMapFacade<K, V>
implements ReadOnlyMap<K, V> {
    protected final @NonNull Supplier<Iterator<Map.Entry<K, V>>> iteratorFunction;
    protected final @NonNull IntSupplier sizeFunction;
    protected final @NonNull Predicate<Object> containsKeyFunction;
    protected final @NonNull Function<K, V> getFunction;

    public ReadOnlyMapFacade(@NonNull ReadOnlyMap<K, V> m) {
        this(m::iterator, m::size, m::containsKey, m::get);
    }

    public ReadOnlyMapFacade(@NonNull Map<K, V> m) {
        this(() -> m.entrySet().iterator(), m::size, m::containsKey, m::get);
    }

    public ReadOnlyMapFacade(@NonNull Supplier<Iterator<Map.Entry<K, V>>> iteratorFunction, @NonNull IntSupplier sizeFunction, @NonNull Predicate<Object> containsKeyFunction, @NonNull Function<K, V> getFunction) {
        this.iteratorFunction = iteratorFunction;
        this.sizeFunction = sizeFunction;
        this.containsKeyFunction = containsKeyFunction;
        this.getFunction = getFunction;
    }

    @Override
    public @Nullable V get(Object key) {
        Object unchecked = key;
        return this.getFunction.apply(unchecked);
    }

    @Override
    public boolean containsKey(Object key) {
        return this.containsKeyFunction.test(key);
    }

    @Override
    public boolean isEmpty() {
        return this.sizeFunction.getAsInt() == 0;
    }

    @Override
    public @NonNull Iterator<Map.Entry<K, V>> iterator() {
        return this.iteratorFunction.get();
    }

    @Override
    public int size() {
        return this.sizeFunction.getAsInt();
    }

    @Override
    public boolean containsEntry(@Nullable Object o) {
        if (o instanceof Map.Entry) {
            Map.Entry entry = (Map.Entry)o;
            Object key = entry.getKey();
            return this.containsKey(key) && Objects.equals(entry.getValue(), this.get(key));
        }
        return false;
    }
}

