/*
 * Decompiled with CFR 0.152.
 */
package org.jhotdraw8.icollection.facade;

import java.util.Comparator;
import java.util.Iterator;
import java.util.Map;
import java.util.NavigableMap;
import java.util.function.Function;
import java.util.function.IntSupplier;
import java.util.function.Predicate;
import java.util.function.Supplier;
import org.jhotdraw8.annotation.NonNull;
import org.jhotdraw8.annotation.Nullable;
import org.jhotdraw8.icollection.facade.ReadOnlyMapFacade;
import org.jhotdraw8.icollection.readonly.ReadOnlyNavigableMap;

public class ReadOnlyNavigableMapFacade<K, V>
extends ReadOnlyMapFacade<K, V>
implements ReadOnlyNavigableMap<K, V> {
    private final @NonNull Supplier<Map.Entry<K, V>> firstEntryFunction;
    private final @NonNull Supplier<Map.Entry<K, V>> lastEntryFunction;
    private final @NonNull Supplier<Iterator<Map.Entry<K, V>>> reverseIteratorFunction;
    private final int characteristics;
    final @NonNull Function<K, Map.Entry<K, V>> ceilingFunction;
    final @NonNull Function<K, Map.Entry<K, V>> floorFunction;
    final @NonNull Function<K, Map.Entry<K, V>> higherFunction;
    final @NonNull Function<K, Map.Entry<K, V>> lowerFunction;
    private final @NonNull Supplier<Comparator<? super K>> comparatorSupplier;

    public ReadOnlyNavigableMapFacade(@NonNull NavigableMap<K, V> target) {
        super(target);
        this.firstEntryFunction = target::firstEntry;
        this.lastEntryFunction = target::lastEntry;
        this.reverseIteratorFunction = () -> target.reversed().sequencedEntrySet().iterator();
        this.characteristics = 81;
        this.comparatorSupplier = target::comparator;
        this.ceilingFunction = target::ceilingEntry;
        this.floorFunction = target::floorEntry;
        this.higherFunction = target::higherEntry;
        this.lowerFunction = target::lowerEntry;
    }

    public ReadOnlyNavigableMapFacade(@NonNull Supplier<Iterator<Map.Entry<K, V>>> iteratorFunction, @NonNull Supplier<Iterator<Map.Entry<K, V>>> reverseIteratorFunction, @NonNull IntSupplier sizeFunction, @NonNull Predicate<Object> containsKeyFunction, @NonNull Function<K, V> getFunction, @NonNull Supplier<Map.Entry<K, V>> firstEntryFunction, @NonNull Supplier<Map.Entry<K, V>> lastEntryFunction, @NonNull Function<K, Map.Entry<K, V>> ceilingFunction, @NonNull Function<K, Map.Entry<K, V>> floorFunction, @NonNull Function<K, Map.Entry<K, V>> higherFunction, @NonNull Function<K, Map.Entry<K, V>> lowerFunction, int characteristics, @Nullable Supplier<Comparator<? super K>> comparator) {
        super(iteratorFunction, sizeFunction, containsKeyFunction, getFunction);
        this.firstEntryFunction = firstEntryFunction;
        this.lastEntryFunction = lastEntryFunction;
        this.reverseIteratorFunction = reverseIteratorFunction;
        this.characteristics = characteristics;
        this.comparatorSupplier = comparator;
        this.ceilingFunction = ceilingFunction;
        this.floorFunction = floorFunction;
        this.higherFunction = higherFunction;
        this.lowerFunction = lowerFunction;
    }

    @Override
    public  @Nullable Map.Entry<K, V> ceilingEntry(K k) {
        return this.ceilingFunction.apply(k);
    }

    @Override
    public  @Nullable Map.Entry<K, V> floorEntry(K k) {
        return this.floorFunction.apply(k);
    }

    @Override
    public  @Nullable Map.Entry<K, V> higherEntry(K k) {
        return this.higherFunction.apply(k);
    }

    @Override
    public  @Nullable Map.Entry<K, V> lowerEntry(K k) {
        return this.lowerFunction.apply(k);
    }

    @Override
    public @NonNull ReadOnlyNavigableMap<K, V> readOnlyReversed() {
        return new ReadOnlyNavigableMapFacade<K, V>(this.reverseIteratorFunction, this.iteratorFunction, this.sizeFunction, this.containsKeyFunction, this.getFunction, this.lastEntryFunction, this.firstEntryFunction, this.floorFunction, this.ceilingFunction, this.lowerFunction, this.higherFunction, this.characteristics, () -> this.comparatorSupplier.get().reversed());
    }

    @Override
    public  @Nullable Map.Entry<K, V> firstEntry() {
        return this.firstEntryFunction.get();
    }

    @Override
    public  @Nullable Map.Entry<K, V> lastEntry() {
        return this.lastEntryFunction.get();
    }

    @Override
    public @Nullable Comparator<? super K> comparator() {
        return this.comparatorSupplier.get();
    }

    @Override
    public int characteristics() {
        return this.characteristics;
    }
}

