/*
 * Decompiled with CFR 0.152.
 */
package org.jhotdraw8.icollection.facade;

import java.util.Comparator;
import java.util.Iterator;
import java.util.NavigableSet;
import java.util.function.Function;
import java.util.function.IntSupplier;
import java.util.function.Predicate;
import java.util.function.Supplier;
import org.jhotdraw8.annotation.NonNull;
import org.jhotdraw8.annotation.Nullable;
import org.jhotdraw8.icollection.facade.ReadOnlySetFacade;
import org.jhotdraw8.icollection.readonly.ReadOnlyNavigableSet;

public class ReadOnlyNavigableSetFacade<E>
extends ReadOnlySetFacade<E>
implements ReadOnlyNavigableSet<E> {
    final @NonNull Supplier<E> getFirstFunction;
    final @NonNull Function<E, E> ceilingFunction;
    final @NonNull Function<E, E> floorFunction;
    final @NonNull Function<E, E> higherFunction;
    final @NonNull Function<E, E> lowerFunction;
    final @NonNull Supplier<E> getLastFunction;
    final @NonNull Supplier<Comparator<? super E>> comparatorSupplier;
    final @NonNull Supplier<Iterator<E>> reverseIteratorFunction;

    public ReadOnlyNavigableSetFacade(@NonNull NavigableSet<E> s) {
        this(s::iterator, () -> s.reversed().iterator(), s::size, s::contains, s::getFirst, s::getLast, s::ceiling, s::floor, s::higher, s::lower, s::comparator, 81);
    }

    public ReadOnlyNavigableSetFacade(@NonNull Supplier<Iterator<E>> iteratorFunction, @NonNull Supplier<Iterator<E>> reverseIteratorFunction, @NonNull IntSupplier sizeFunction, @NonNull Predicate<Object> containsFunction, @NonNull Supplier<E> getFirstFunction, @NonNull Supplier<E> getLastFunction, @NonNull Function<E, E> ceilingFunction, @NonNull Function<E, E> floorFunction, @NonNull Function<E, E> higherFunction, @NonNull Function<E, E> lowerFunction, @NonNull Supplier<Comparator<? super E>> comparatorSupplier, int characteristics) {
        super(iteratorFunction, sizeFunction, containsFunction, characteristics);
        this.getFirstFunction = getFirstFunction;
        this.getLastFunction = getLastFunction;
        this.reverseIteratorFunction = reverseIteratorFunction;
        this.ceilingFunction = ceilingFunction;
        this.floorFunction = floorFunction;
        this.higherFunction = higherFunction;
        this.lowerFunction = lowerFunction;
        this.comparatorSupplier = comparatorSupplier;
    }

    @Override
    public @Nullable E ceiling(E e) {
        return this.ceilingFunction.apply(e);
    }

    @Override
    public @Nullable Comparator<? super E> comparator() {
        return this.comparatorSupplier.get();
    }

    @Override
    public @Nullable E floor(E e) {
        return this.floorFunction.apply(e);
    }

    @Override
    public @Nullable E higher(E e) {
        return this.higherFunction.apply(e);
    }

    @Override
    public @Nullable E lower(E e) {
        return this.lowerFunction.apply(e);
    }

    @Override
    public E getFirst() {
        return this.getFirstFunction.get();
    }

    @Override
    public E getLast() {
        return this.getLastFunction.get();
    }

    @Override
    public @NonNull ReadOnlyNavigableSet<E> readOnlyReversed() {
        return new ReadOnlyNavigableSetFacade<E>(this.reverseIteratorFunction, this.iteratorFunction, this.sizeFunction, this.containsFunction, this.getLastFunction, this.getFirstFunction, this.floorFunction, this.ceilingFunction, this.lowerFunction, this.higherFunction, () -> this.comparatorSupplier.get().reversed(), this.characteristics);
    }
}

