/*
 * Decompiled with CFR 0.152.
 */
package org.jhotdraw8.icollection.immutable;

import java.util.Collection;
import java.util.function.Predicate;
import org.jhotdraw8.annotation.NonNull;
import org.jhotdraw8.icollection.readonly.ReadOnlyCollection;

public interface ImmutableCollection<E>
extends ReadOnlyCollection<E> {
    public @NonNull ImmutableCollection<E> add(E var1);

    public @NonNull ImmutableCollection<E> addAll(@NonNull Iterable<? extends E> var1);

    public <T> @NonNull ImmutableCollection<T> empty();

    default public ImmutableCollection<E> filter(@NonNull Predicate<E> p) {
        ImmutableCollection result = this.empty();
        for (Object e : this) {
            if (!p.test(e)) continue;
            result = result.add(e);
        }
        return result;
    }

    public int maxSize();

    public @NonNull ImmutableCollection<E> remove(E var1);

    public @NonNull ImmutableCollection<E> removeAll(@NonNull Iterable<?> var1);

    public @NonNull ImmutableCollection<E> retainAll(@NonNull Iterable<?> var1);

    public @NonNull Collection<E> toMutable();
}

