/*
 * Decompiled with CFR 0.152.
 */
package org.jhotdraw8.icollection.impl;

import java.lang.reflect.Array;
import java.util.Arrays;
import java.util.Objects;
import java.util.function.BiPredicate;
import org.jhotdraw8.annotation.NonNull;
import org.jhotdraw8.icollection.impl.Preconditions;

public class ArrayHelper {
    private ArrayHelper() {
    }

    public static <T> boolean equals(T @NonNull [] a, int aFrom, int aTo, T @NonNull [] b, int bFrom, int bTo) {
        return ArrayHelper.equals(a, aFrom, aTo, b, bFrom, bTo, Objects::equals);
    }

    public static <T> boolean equals(T @NonNull [] a, int aFrom, int aTo, T @NonNull [] b, int bFrom, int bTo, @NonNull BiPredicate<T, T> cmp) {
        Preconditions.checkFromToIndex(aFrom, aTo, a.length);
        Preconditions.checkFromToIndex(bFrom, bTo, b.length);
        int aLength = aTo - aFrom;
        int bLength = bTo - bFrom;
        if (aLength != bLength) {
            return false;
        }
        for (int i = 0; i < aLength; ++i) {
            if (cmp.test(a[aFrom++], b[bFrom++])) continue;
            return false;
        }
        return true;
    }

    public static <T> @NonNull T @NonNull [] copyAdd(@NonNull T @NonNull [] src, int index, T value) {
        T[] dst = ArrayHelper.copyComponentAdd(src, index, 1);
        dst[index] = value;
        return dst;
    }

    public static <T> @NonNull T @NonNull [] copyAddAll(@NonNull T @NonNull [] src, int index, @NonNull T @NonNull [] values) {
        T[] dst = ArrayHelper.copyComponentAdd(src, index, values.length);
        System.arraycopy(values, 0, dst, index, values.length);
        return dst;
    }

    public static <T> @NonNull T @NonNull [] copyComponentAdd(@NonNull T @NonNull [] src, int index, int numComponents) {
        if (index == src.length) {
            return Arrays.copyOf(src, src.length + numComponents);
        }
        Object[] dst = (Object[])Array.newInstance(src.getClass().getComponentType(), src.length + numComponents);
        System.arraycopy(src, 0, dst, 0, index);
        System.arraycopy(src, index, dst, index + numComponents, src.length - index);
        return dst;
    }

    public static <T> @NonNull T @NonNull [] copyComponentRemove(@NonNull T @NonNull [] src, int index, int numComponents) {
        if (index == src.length - numComponents) {
            return Arrays.copyOf(src, src.length - numComponents);
        }
        Object[] dst = (Object[])Array.newInstance(src.getClass().getComponentType(), src.length - numComponents);
        System.arraycopy(src, 0, dst, 0, index);
        System.arraycopy(src, index + numComponents, dst, index, src.length - index - numComponents);
        return dst;
    }

    public static <T> @NonNull T @NonNull [] copyRemove(@NonNull T @NonNull [] src, int index) {
        return ArrayHelper.copyComponentRemove(src, index, 1);
    }

    public static <T> @NonNull T @NonNull [] copySet(@NonNull T @NonNull [] src, int index, T value) {
        T[] dst = Arrays.copyOf(src, src.length);
        dst[index] = value;
        return dst;
    }
}

