/*
 * Decompiled with CFR 0.152.
 */
package org.jhotdraw8.icollection.impl.champ;

import java.io.Serializable;
import java.util.AbstractSet;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.function.Predicate;
import java.util.stream.Stream;
import org.jhotdraw8.annotation.NonNull;
import org.jhotdraw8.annotation.Nullable;
import org.jhotdraw8.icollection.impl.IdentityObject;
import org.jhotdraw8.icollection.impl.champ.BitmapIndexedNode;
import org.jhotdraw8.icollection.readonly.ReadOnlyCollection;
import org.jhotdraw8.icollection.readonly.ReadOnlySet;

public abstract class AbstractMutableChampSet<E, D>
extends AbstractSet<E>
implements Serializable,
Cloneable,
ReadOnlySet<E> {
    private static final long serialVersionUID = 0L;
    protected @Nullable IdentityObject owner;
    protected BitmapIndexedNode<D> root;
    protected int size;
    protected transient int modCount;

    @Override
    public boolean addAll(@NonNull Collection<? extends E> c) {
        return this.addAll((Iterable<? extends E>)c);
    }

    @Override
    public boolean addAll(@NonNull Iterable<? extends E> c) {
        boolean added = false;
        for (E e : c) {
            added |= this.add(e);
        }
        return added;
    }

    @Override
    public boolean retainAll(@NonNull Iterable<?> c) {
        Predicate<Object> predicate;
        ReadOnlyCollection rc;
        Collection cc;
        if (c == this || this.isEmpty()) {
            return false;
        }
        if (c instanceof Collection && (cc = (Collection)c).isEmpty() || c instanceof ReadOnlyCollection && (rc = (ReadOnlyCollection)c).isEmpty()) {
            this.clear();
            return true;
        }
        if (c instanceof Collection) {
            Collection that = (Collection)c;
            predicate = that::contains;
        } else if (c instanceof ReadOnlyCollection) {
            ReadOnlyCollection that = (ReadOnlyCollection)c;
            predicate = that::contains;
        } else {
            HashSet that = new HashSet();
            c.forEach(that::add);
            predicate = that::contains;
        }
        boolean removed = false;
        Iterator<E> i = this.iterator();
        while (i.hasNext()) {
            E e = i.next();
            if (predicate.test(e)) continue;
            i.remove();
            removed = true;
        }
        return removed;
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o instanceof AbstractMutableChampSet) {
            AbstractMutableChampSet that = (AbstractMutableChampSet)o;
            return this.size == that.size && this.root.equivalent(that.root);
        }
        return super.equals(o);
    }

    protected int getModCount() {
        return this.modCount;
    }

    @Override
    public int size() {
        return this.size;
    }

    protected @NonNull IdentityObject makeOwner() {
        if (this.owner == null) {
            this.owner = new IdentityObject();
        }
        return this.owner;
    }

    @Override
    public boolean removeAll(@NonNull Collection<?> c) {
        return this.removeAll((Iterable<?>)c);
    }

    @Override
    public boolean removeAll(@NonNull Iterable<?> c) {
        if (this.isEmpty()) {
            return false;
        }
        if (c == this) {
            this.clear();
            return true;
        }
        boolean modified = false;
        for (Object o : c) {
            modified |= this.remove(o);
        }
        return modified;
    }

    @Override
    public Stream<E> stream() {
        return super.stream();
    }

    public @NonNull AbstractMutableChampSet<E, D> clone() {
        try {
            this.owner = null;
            return (AbstractMutableChampSet)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new InternalError(e);
        }
    }

    @Override
    public abstract @NonNull Iterator<E> iterator();
}

