/*
 * Decompiled with CFR 0.152.
 */
package org.jhotdraw8.icollection.impl.champ;

import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.function.Function;
import org.jhotdraw8.annotation.NonNull;
import org.jhotdraw8.annotation.Nullable;
import org.jhotdraw8.icollection.impl.champ.Node;

public class ChampIterator<K, E>
implements Iterator<E> {
    private final @NonNull Function<K, E> mappingFunction;
    private static final int MAX_DEPTH = 7;
    protected int currentValueCursor;
    protected int currentValueLength;
    protected Node<K> currentValueNode;
    private int currentStackLevel = -1;
    private final int[] indexAndArity = new int[14];
    final Node<K>[] nodes = new Node[7];

    public ChampIterator(@NonNull Node<K> rootNode, @Nullable Function<K, E> mappingFunction) {
        Function<Object, Object> function = this.mappingFunction = mappingFunction == null ? k -> k : mappingFunction;
        if (rootNode.hasNodes()) {
            this.currentStackLevel = 0;
            this.nodes[0] = rootNode;
            this.indexAndArity[0] = 0;
            this.indexAndArity[1] = rootNode.nodeArity();
        }
        if (rootNode.hasData()) {
            this.currentValueNode = rootNode;
            this.currentValueCursor = 0;
            this.currentValueLength = rootNode.dataArity();
        }
    }

    private boolean searchNextValueNode() {
        while (this.currentStackLevel >= 0) {
            int index = this.currentStackLevel << 1;
            if (this.indexAndArity[index] < this.indexAndArity[index + 1]) {
                Node<K> nextNode = this.nodes[this.currentStackLevel].getNode(this.indexAndArity[index]);
                int n = index;
                this.indexAndArity[n] = this.indexAndArity[n] + 1;
                if (nextNode.hasNodes()) {
                    ++this.currentStackLevel;
                    this.nodes[this.currentStackLevel] = nextNode;
                    this.indexAndArity[index += 2] = 0;
                    this.indexAndArity[index + 1] = nextNode.nodeArity();
                }
                if (!nextNode.hasData()) continue;
                this.currentValueNode = nextNode;
                this.currentValueCursor = 0;
                this.currentValueLength = nextNode.dataArity();
                return true;
            }
            --this.currentStackLevel;
        }
        return false;
    }

    @Override
    public boolean hasNext() {
        return this.currentValueCursor < this.currentValueLength || this.searchNextValueNode();
    }

    @Override
    public E next() {
        if (!this.hasNext()) {
            throw new NoSuchElementException();
        }
        return this.mappingFunction.apply(this.currentValueNode.getData(this.currentValueCursor++));
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException();
    }
}

