/*
 * Decompiled with CFR 0.152.
 */
package org.jhotdraw8.icollection.impl.champ;

import java.util.Arrays;
import java.util.Objects;
import java.util.function.BiFunction;
import java.util.function.BiPredicate;
import java.util.function.Predicate;
import java.util.function.ToIntFunction;
import org.jhotdraw8.annotation.NonNull;
import org.jhotdraw8.annotation.Nullable;
import org.jhotdraw8.icollection.impl.IdentityObject;
import org.jhotdraw8.icollection.impl.champ.BitmapIndexedNode;
import org.jhotdraw8.icollection.impl.champ.BulkChangeEvent;
import org.jhotdraw8.icollection.impl.champ.ChangeEvent;
import org.jhotdraw8.icollection.impl.champ.Node;
import org.jhotdraw8.icollection.impl.champ.NodeFactory;
import org.jhotdraw8.icollection.util.ListHelper;

class HashCollisionNode<D>
extends Node<D> {
    private static final HashCollisionNode<?> EMPTY = new HashCollisionNode(0, new Object[0]);
    private final int hash;
    @NonNull Object[] data;

    HashCollisionNode(int hash, Object @NonNull [] data) {
        this.data = data;
        this.hash = hash;
    }

    @Override
    int dataArity() {
        return this.data.length;
    }

    @Override
    boolean hasDataArityOne() {
        return false;
    }

    @Override
    boolean equivalent(@NonNull Object other) {
        if (this == other) {
            return true;
        }
        HashCollisionNode that = (HashCollisionNode)other;
        @NonNull Object[] thatEntries = that.data;
        if (this.hash != that.hash || thatEntries.length != this.data.length) {
            return false;
        }
        @NonNull Object[] thatEntriesCloned = (Object[])thatEntries.clone();
        int remainingLength = thatEntriesCloned.length;
        block0: for (Object key : this.data) {
            for (int j = 0; j < remainingLength; ++j) {
                Object todoKey = thatEntriesCloned[j];
                if (!Objects.equals(todoKey, key)) continue;
                System.arraycopy(thatEntriesCloned, remainingLength - 1, thatEntriesCloned, j, 1);
                --remainingLength;
                continue block0;
            }
            return false;
        }
        return true;
    }

    @Override
    @Nullable Object find(D key, int dataHash, int shift, @NonNull BiPredicate<D, D> equalsFunction) {
        for (Object entry : this.data) {
            if (!equalsFunction.test(key, entry)) continue;
            return entry;
        }
        return NO_DATA;
    }

    @Override
    @NonNull D getData(int index) {
        return (D)this.data[index];
    }

    @Override
    @NonNull Node<D> getNode(int index) {
        throw new IllegalStateException("Is leaf node.");
    }

    @Override
    @NonNull Object getNodeRaw(int index) {
        throw new IllegalStateException("Is leaf node.");
    }

    @Override
    boolean hasData() {
        return this.data.length > 0;
    }

    @Override
    boolean hasNodes() {
        return false;
    }

    @Override
    int nodeArity() {
        return 0;
    }

    @Override
    @NonNull Node<D> remove(@Nullable IdentityObject owner, D data, int dataHash, int shift, @NonNull ChangeEvent<D> details, @NonNull BiPredicate<D, D> equalsFunction) {
        int idx = 0;
        int i = 0;
        while (i < this.data.length) {
            if (equalsFunction.test(this.data[i], data)) {
                Object currentVal = this.data[i];
                details.setRemoved(currentVal);
                if (this.data.length == 1) {
                    return BitmapIndexedNode.emptyNode();
                }
                if (this.data.length == 2) {
                    return NodeFactory.newBitmapIndexedNode(owner, 0, HashCollisionNode.bitpos(HashCollisionNode.mask(dataHash, 0)), new Object[]{this.getData(idx ^ 1)});
                }
                Object[] entriesNew = ListHelper.copyComponentRemove(this.data, idx, 1);
                if (this.isAllowedToUpdate(owner)) {
                    this.data = entriesNew;
                    return this;
                }
                return NodeFactory.newHashCollisionNode(owner, dataHash, entriesNew);
            }
            ++i;
            ++idx;
        }
        return this;
    }

    @Override
    @NonNull Node<D> put(@Nullable IdentityObject owner, D newData, int dataHash, int shift, @NonNull ChangeEvent<D> details, @NonNull BiFunction<D, D, D> updateFunction, @NonNull BiPredicate<D, D> equalsFunction, @NonNull ToIntFunction<D> hashFunction) {
        assert (this.hash == dataHash);
        for (int i = 0; i < this.data.length; ++i) {
            Object oldData = this.data[i];
            if (!equalsFunction.test(oldData, newData)) continue;
            D updatedData = updateFunction.apply(oldData, newData);
            if (updatedData == oldData) {
                details.found(oldData);
                return this;
            }
            details.setReplaced(oldData, updatedData);
            if (this.isAllowedToUpdate(owner)) {
                this.data[i] = updatedData;
                return this;
            }
            Object[] newKeys = ListHelper.copySet(this.data, i, updatedData);
            return NodeFactory.newHashCollisionNode(owner, dataHash, newKeys);
        }
        Object[] entriesNew = ListHelper.copyComponentAdd(this.data, this.data.length, 1);
        entriesNew[this.data.length] = newData;
        details.setAdded(newData);
        if (this.isAllowedToUpdate(owner)) {
            this.data = entriesNew;
            return this;
        }
        return NodeFactory.newHashCollisionNode(owner, dataHash, entriesNew);
    }

    @Override
    protected int calculateSize() {
        return this.dataArity();
    }

    @Override
    protected @NonNull Node<D> putAll(@Nullable IdentityObject owner, @NonNull Node<D> otherNode, int shift, @NonNull BulkChangeEvent bulkChange, @NonNull BiFunction<D, D, D> updateFunction, @NonNull BiPredicate<D, D> equalsFunction, @NonNull ToIntFunction<D> hashFunction, @NonNull ChangeEvent<D> details) {
        if (otherNode == this) {
            bulkChange.inBoth += this.dataArity();
            return this;
        }
        HashCollisionNode that = (HashCollisionNode)otherNode;
        int thisSize = this.dataArity();
        int thatSize = that.dataArity();
        Object[] buffer = Arrays.copyOf(this.data, thisSize + thatSize);
        System.arraycopy(this.data, 0, buffer, 0, this.data.length);
        Object[] thatArray = that.data;
        int resultSize = thisSize;
        int unprocessedSize = thisSize;
        boolean updated = false;
        block0: for (int i = 0; i < thatSize; ++i) {
            Object thatData = thatArray[i];
            for (int j = 0; j < unprocessedSize; ++j) {
                Object thisData = buffer[j];
                if (!equalsFunction.test(thatData, thisData)) continue;
                Object swap = buffer[--unprocessedSize];
                D updatedData = updateFunction.apply(thisData, thatData);
                updated |= updatedData != thisData;
                buffer[unprocessedSize] = updatedData;
                buffer[j] = swap;
                ++bulkChange.inBoth;
                continue block0;
            }
            buffer[resultSize++] = thatData;
        }
        return this.newCroppedHashCollisionNode(updated | resultSize != thisSize, buffer, resultSize);
    }

    @Override
    protected @NonNull Node<D> removeAll(@Nullable IdentityObject owner, @NonNull Node<D> otherNode, int shift, @NonNull BulkChangeEvent bulkChange, @NonNull BiFunction<D, D, D> updateFunction, @NonNull BiPredicate<D, D> equalsFunction, @NonNull ToIntFunction<D> hashFunction, @NonNull ChangeEvent<D> details) {
        if (otherNode == this) {
            bulkChange.removed += this.dataArity();
            return EMPTY;
        }
        HashCollisionNode that = (HashCollisionNode)otherNode;
        int thisSize = this.dataArity();
        int thatSize = that.dataArity();
        int resultSize = thisSize;
        Object[] buffer = (Object[])this.data.clone();
        Object[] thatArray = that.data;
        block0: for (int i = 0; i < thatSize && resultSize > 0; ++i) {
            Object thatData = thatArray[i];
            for (int j = 0; j < resultSize; ++j) {
                Object thisData = buffer[j];
                if (!equalsFunction.test(thatData, thisData)) continue;
                buffer[j] = buffer[--resultSize];
                ++bulkChange.removed;
                continue block0;
            }
        }
        return this.newCroppedHashCollisionNode(thisSize != resultSize, buffer, resultSize);
    }

    private @NonNull HashCollisionNode<D> newCroppedHashCollisionNode(boolean changed, Object[] buffer, int size) {
        if (changed) {
            if (buffer.length != size) {
                buffer = Arrays.copyOf(buffer, size);
            }
            return new HashCollisionNode<D>(this.hash, buffer);
        }
        return this;
    }

    @Override
    protected @NonNull Node<D> retainAll(IdentityObject owner, @NonNull Node<D> otherNode, int shift, @NonNull BulkChangeEvent bulkChange, @NonNull BiFunction<D, D, D> updateFunction, @NonNull BiPredicate<D, D> equalsFunction, @NonNull ToIntFunction<D> hashFunction, @NonNull ChangeEvent<D> details) {
        if (otherNode == this) {
            bulkChange.removed += this.dataArity();
            return EMPTY;
        }
        HashCollisionNode that = (HashCollisionNode)otherNode;
        int thisSize = this.dataArity();
        int thatSize = that.dataArity();
        int resultSize = 0;
        Object[] buffer = (Object[])this.data.clone();
        Object[] thatArray = that.data;
        block0: for (int i = 0; i < thatSize && thisSize != resultSize; ++i) {
            Object thatData = thatArray[i];
            for (int j = resultSize; j < thisSize; ++j) {
                Object thisData = buffer[j];
                if (!equalsFunction.test(thatData, thisData)) continue;
                Object swap = buffer[resultSize];
                buffer[resultSize++] = thisData;
                buffer[j] = swap;
                continue block0;
            }
            ++bulkChange.removed;
        }
        return this.newCroppedHashCollisionNode(thisSize != resultSize, buffer, resultSize);
    }

    @Override
    protected @NonNull Node<D> filterAll(@Nullable IdentityObject owner, Predicate<? super D> predicate, int shift, @NonNull BulkChangeEvent bulkChange) {
        int thisSize = this.dataArity();
        int resultSize = 0;
        Object[] buffer = new Object[thisSize];
        Object[] thisArray = this.data;
        for (int i = 0; i < thisSize; ++i) {
            Object thisData = thisArray[i];
            if (predicate.test(thisData)) {
                buffer[resultSize++] = thisData;
                continue;
            }
            ++bulkChange.removed;
        }
        return this.newCroppedHashCollisionNode(thisSize != resultSize, buffer, resultSize);
    }
}

