/*
 * Decompiled with CFR 0.152.
 */
package org.jhotdraw8.icollection.impl.champmap;

import java.io.Serializable;
import java.util.AbstractMap;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Objects;
import java.util.function.Predicate;
import org.jhotdraw8.annotation.NonNull;
import org.jhotdraw8.annotation.Nullable;
import org.jhotdraw8.icollection.impl.IdentityObject;
import org.jhotdraw8.icollection.impl.champmap.BitmapIndexedNode;
import org.jhotdraw8.icollection.readonly.ReadOnlyCollection;
import org.jhotdraw8.icollection.readonly.ReadOnlyMap;

public abstract class AbstractMutableChampMap<K, V>
extends AbstractMap<K, V>
implements Serializable,
Cloneable,
ReadOnlyMap<K, V> {
    private static final long serialVersionUID = 0L;
    protected @Nullable IdentityObject owner;
    protected BitmapIndexedNode<K, V> root;
    protected int size;
    protected int modCount;

    protected @NonNull IdentityObject getOrCreateOwner() {
        if (this.owner == null) {
            this.owner = new IdentityObject();
        }
        return this.owner;
    }

    @Override
    public @NonNull AbstractMutableChampMap<K, V> clone() {
        try {
            this.owner = null;
            return (AbstractMutableChampMap)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new InternalError(e);
        }
    }

    @Override
    public int size() {
        return this.size;
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o instanceof AbstractMutableChampMap) {
            AbstractMutableChampMap that = (AbstractMutableChampMap)o;
            return this.size == that.size && this.root.equivalent(that.root);
        }
        return super.equals(o);
    }

    @Override
    public V getOrDefault(@NonNull Object key, V defaultValue) {
        return super.getOrDefault(key, defaultValue);
    }

    protected int getModCount() {
        return this.modCount;
    }

    public boolean putAll(@NonNull Iterable<? extends Map.Entry<? extends K, ? extends V>> c) {
        if (c == this) {
            return false;
        }
        boolean modified = false;
        for (Map.Entry<K, V> e : c) {
            V value = e.getValue();
            if (value == null && !this.containsKey(e.getKey())) {
                modified = true;
            }
            V oldValue = this.put(e.getKey(), value);
            modified = modified || !Objects.equals(oldValue, value);
        }
        return modified;
    }

    public boolean removeAll(@NonNull Iterable<?> c) {
        if (this.isEmpty()) {
            return false;
        }
        boolean modified = false;
        for (Object o : c) {
            if (!this.containsKey(o)) continue;
            this.remove(o);
            modified = true;
        }
        return modified;
    }

    public boolean retainAll(@NonNull Iterable<?> c) {
        Predicate<Object> predicate;
        ReadOnlyCollection rc;
        Collection cc;
        if (this.isEmpty()) {
            return false;
        }
        if (c instanceof Collection && (cc = (Collection)c).isEmpty() || c instanceof ReadOnlyCollection && (rc = (ReadOnlyCollection)c).isEmpty()) {
            this.clear();
            return true;
        }
        if (c instanceof Collection) {
            Collection that = (Collection)c;
            predicate = that::contains;
        } else if (c instanceof ReadOnlyCollection) {
            ReadOnlyCollection that = (ReadOnlyCollection)c;
            predicate = that::contains;
        } else {
            HashSet that = new HashSet();
            c.forEach(that::add);
            predicate = that::contains;
        }
        boolean removed = false;
        Iterator i = this.iterator();
        while (i.hasNext()) {
            Map.Entry e = i.next();
            if (predicate.test(e.getKey())) continue;
            i.remove();
            removed = true;
        }
        return removed;
    }

    protected boolean removeEntry(@Nullable Object o) {
        if (this.containsEntry(o)) {
            assert (o != null);
            this.remove(((Map.Entry)o).getKey());
            return true;
        }
        return false;
    }
}

