/*
 * Decompiled with CFR 0.152.
 */
package org.jhotdraw8.icollection.impl.champmap;

import java.util.Iterator;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import org.jhotdraw8.annotation.NonNull;
import org.jhotdraw8.annotation.Nullable;
import org.jhotdraw8.icollection.impl.champmap.EditableMapEntry;
import org.jhotdraw8.icollection.impl.champmap.Node;

public class EntryIterator<K, V>
implements Iterator<Map.Entry<K, V>> {
    private final int[] nodeCursorsAndLengths = new int[16];
    int nextValueCursor;
    private int nextValueLength;
    private int nextStackLevel = -1;
    Node<K, V> nextValueNode;
    @Nullable EditableMapEntry<K, V> current;
    private boolean canRemove = false;
    private final @Nullable Consumer<K> persistentRemoveFunction;
    private final @Nullable BiConsumer<K, V> persistentPutIfPresentFunction;
    final Node<K, V> @NonNull [] nodes = new Node[8];

    public EntryIterator(@NonNull Node<K, V> rootNode, @Nullable Consumer<K> persistentRemoveFunction, @Nullable BiConsumer<K, V> persistentPutIfPresentFunction) {
        this.persistentRemoveFunction = persistentRemoveFunction;
        this.persistentPutIfPresentFunction = persistentPutIfPresentFunction;
        if (rootNode.hasNodes()) {
            this.nextStackLevel = 0;
            this.nodes[0] = rootNode;
            this.nodeCursorsAndLengths[0] = 0;
            this.nodeCursorsAndLengths[1] = rootNode.nodeArity();
        }
        if (rootNode.hasData()) {
            this.nextValueNode = rootNode;
            this.nextValueCursor = 0;
            this.nextValueLength = rootNode.dataArity();
        }
    }

    @Override
    public boolean hasNext() {
        if (this.nextValueCursor < this.nextValueLength) {
            return true;
        }
        return this.searchNextValueNode();
    }

    @Override
    public @Nullable EditableMapEntry<K, V> next() {
        if (!this.hasNext()) {
            throw new NoSuchElementException();
        }
        this.canRemove = true;
        this.current = this.nextValueNode.getMapEntry(this.nextValueCursor++);
        this.current.setPutIfPresentFunction(this.persistentPutIfPresentFunction);
        return this.current;
    }

    private boolean searchNextValueNode() {
        while (this.nextStackLevel >= 0) {
            int currentCursorIndex = this.nextStackLevel * 2;
            int nodeCursor = this.nodeCursorsAndLengths[currentCursorIndex];
            int currentLengthIndex = currentCursorIndex + 1;
            int nodeLength = this.nodeCursorsAndLengths[currentLengthIndex];
            if (nodeCursor < nodeLength) {
                Node<K, V> nextNode = this.nodes[this.nextStackLevel].getNode(nodeCursor);
                int n = currentCursorIndex;
                this.nodeCursorsAndLengths[n] = this.nodeCursorsAndLengths[n] + 1;
                if (nextNode.hasNodes()) {
                    int nextStackLevel = ++this.nextStackLevel;
                    int nextCursorIndex = nextStackLevel * 2;
                    int nextLengthIndex = nextCursorIndex + 1;
                    this.nodes[nextStackLevel] = nextNode;
                    this.nodeCursorsAndLengths[nextCursorIndex] = 0;
                    this.nodeCursorsAndLengths[nextLengthIndex] = nextNode.nodeArity();
                }
                if (!nextNode.hasData()) continue;
                this.nextValueNode = nextNode;
                this.nextValueCursor = 0;
                this.nextValueLength = nextNode.dataArity();
                return true;
            }
            --this.nextStackLevel;
        }
        return false;
    }

    @Override
    public void remove() {
        if (this.persistentRemoveFunction == null) {
            throw new UnsupportedOperationException("remove");
        }
        if (!this.canRemove || this.current == null) {
            throw new IllegalStateException();
        }
        EditableMapEntry<K, V> toRemove = this.current;
        this.persistentRemoveFunction.accept(toRemove.getKey());
        this.canRemove = false;
        this.current = null;
    }
}

