/*
 * Decompiled with CFR 0.152.
 */
package org.jhotdraw8.icollection.impl.iteration;

import java.util.ConcurrentModificationException;
import java.util.Iterator;
import java.util.function.Consumer;
import java.util.function.IntSupplier;
import org.jhotdraw8.annotation.NonNull;
import org.jhotdraw8.annotation.Nullable;

public class FailFastIterator<E>
implements Iterator<E> {
    private final @NonNull Iterator<? extends E> i;
    private int expectedModCount;
    private final @NonNull IntSupplier modCountSupplier;
    private final @NonNull Consumer<E> removeFunction;
    private @Nullable E current;
    private boolean canRemove;

    public FailFastIterator(@NonNull Iterator<? extends E> i, @NonNull IntSupplier modCountSupplier) {
        this(i, e -> i.remove(), modCountSupplier);
    }

    public FailFastIterator(@NonNull Iterator<? extends E> i, @NonNull Consumer<E> removeFunction, @NonNull IntSupplier modCountSupplier) {
        this.i = i;
        this.modCountSupplier = modCountSupplier;
        this.expectedModCount = modCountSupplier.getAsInt();
        this.removeFunction = removeFunction;
    }

    @Override
    public boolean hasNext() {
        this.ensureUnmodified();
        return this.i.hasNext();
    }

    @Override
    public E next() {
        this.ensureUnmodified();
        this.current = this.i.next();
        this.canRemove = true;
        return this.current;
    }

    protected void ensureUnmodified() {
        if (this.expectedModCount != this.modCountSupplier.getAsInt()) {
            throw new ConcurrentModificationException();
        }
    }

    @Override
    public void remove() {
        if (!this.canRemove) {
            throw new IllegalStateException();
        }
        this.ensureUnmodified();
        this.removeFunction.accept(this.current);
        this.expectedModCount = this.modCountSupplier.getAsInt();
        this.canRemove = false;
    }
}

