/*
 * Decompiled with CFR 0.152.
 */
package org.jhotdraw8.icollection.impl.iteration;

import java.util.ConcurrentModificationException;
import java.util.List;
import java.util.ListIterator;
import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.function.IntSupplier;
import org.jhotdraw8.annotation.NonNull;

public class MutableListIterator<E>
implements ListIterator<E> {
    private final @NonNull List<E> src;
    int index;
    int lastReturned = -1;
    private final @NonNull IntSupplier modCount;
    private int expectedCount;

    public MutableListIterator(@NonNull List<E> src, int index, @NonNull IntSupplier modCount) {
        Objects.checkIndex(index, src.size() + 1);
        this.src = src;
        this.index = index;
        this.modCount = modCount;
        this.expectedCount = modCount.getAsInt();
    }

    @Override
    public boolean hasNext() {
        this.ensureUnmodified();
        return this.index < this.src.size();
    }

    @Override
    public E next() {
        this.ensureUnmodified();
        if (!this.hasNext()) {
            throw new NoSuchElementException();
        }
        return this.get(this.index++);
    }

    @Override
    public boolean hasPrevious() {
        this.ensureUnmodified();
        return this.index > 0;
    }

    @Override
    public E previous() {
        this.ensureUnmodified();
        if (!this.hasPrevious()) {
            throw new NoSuchElementException();
        }
        return this.get(--this.index);
    }

    @Override
    public int nextIndex() {
        this.ensureUnmodified();
        return this.index;
    }

    @Override
    public int previousIndex() {
        this.ensureUnmodified();
        return this.index - 1;
    }

    @Override
    public void remove() {
        this.ensureUnmodified();
        if (this.lastReturned < 0) {
            throw new IllegalStateException();
        }
        try {
            this.src.remove(this.lastReturned);
            this.lastReturned = -1;
            if (this.index > 0) {
                --this.index;
            }
            this.updateModified();
        }
        catch (IndexOutOfBoundsException ex) {
            throw new ConcurrentModificationException();
        }
    }

    private E get(int index) {
        this.ensureUnmodified();
        this.lastReturned = index;
        return this.src.get(index);
    }

    @Override
    public void set(E e) {
        this.ensureUnmodified();
        if (this.lastReturned < 0) {
            throw new IllegalStateException();
        }
        try {
            this.src.set(this.lastReturned, e);
            this.updateModified();
        }
        catch (IndexOutOfBoundsException ex) {
            throw new ConcurrentModificationException();
        }
    }

    @Override
    public void add(E e) {
        this.ensureUnmodified();
        try {
            int i = this.index;
            this.src.add(this.index, e);
            this.index = i + 1;
            this.lastReturned = -1;
            this.updateModified();
        }
        catch (IndexOutOfBoundsException ex) {
            throw new ConcurrentModificationException();
        }
    }

    protected void ensureUnmodified() {
        if (this.expectedCount != this.modCount.getAsInt()) {
            throw new ConcurrentModificationException();
        }
    }

    protected void updateModified() {
        this.expectedCount = this.modCount.getAsInt();
    }
}

