/*
 * Decompiled with CFR 0.152.
 */
package org.jhotdraw8.icollection.impl.redblack;

import java.util.Comparator;
import java.util.Map;
import java.util.Objects;
import java.util.function.BiFunction;
import org.jhotdraw8.annotation.NonNull;
import org.jhotdraw8.annotation.Nullable;
import org.jhotdraw8.icollection.impl.redblack.Empty;
import org.jhotdraw8.icollection.impl.redblack.RedBlackTree;
import org.jhotdraw8.icollection.impl.redblack.Tuple;
import org.jhotdraw8.icollection.impl.redblack.Tuple2;
import org.jhotdraw8.icollection.impl.redblack.Tuple4;

public final class Node<K, V>
implements RedBlackTree<K, V>,
Map.Entry<K, V> {
    final RedBlackTree<K, V> left;
    final K key;
    final V value;
    final RedBlackTree<K, V> right;
    final int sizeAndColor;

    Node(boolean color, RedBlackTree<K, V> left, K key, V value, RedBlackTree<K, V> right) {
        this.left = left;
        this.key = key;
        this.value = value;
        this.right = right;
        int size = left.size() + right.size() + 1;
        this.sizeAndColor = color ? -size : size;
    }

    private static <K, V> Node<K, V> balanceLeft(boolean color, RedBlackTree<K, V> left, K key, V value, RedBlackTree<K, V> right) {
        Node ln;
        if (!color && !left.isEmpty() && (ln = (Node)left).color()) {
            Node lrn;
            Node lln;
            if (!ln.left.isEmpty() && (lln = (Node)ln.left).color()) {
                Node<K, V> newLeft = new Node<K, V>(false, lln.left, lln.key, lln.value, lln.right);
                Node<K, V> newRight = new Node<K, V>(false, ln.right, key, value, right);
                return new Node<K, V>(true, newLeft, ln.key, ln.value, newRight);
            }
            if (!ln.right.isEmpty() && (lrn = (Node)ln.right).color()) {
                Node<K, V> newLeft = new Node<K, V>(false, ln.left, ln.key, ln.value, lrn.left);
                Node<K, V> newRight = new Node<K, V>(false, lrn.right, key, value, right);
                return new Node<K, V>(true, newLeft, lrn.key, lrn.value, newRight);
            }
        }
        return new Node<K, V>(color, left, key, value, right);
    }

    private static <K, V> Node<K, V> balanceRight(boolean color, RedBlackTree<K, V> left, K key, V value, RedBlackTree<K, V> right) {
        Node rn;
        if (!color && !right.isEmpty() && (rn = (Node)right).color()) {
            Node rln;
            Node rrn;
            if (!rn.right.isEmpty() && (rrn = (Node)rn.right).color()) {
                Node<K, V> newLeft = new Node<K, V>(false, left, key, value, rn.left);
                Node<K, V> newRight = new Node<K, V>(false, rrn.left, rrn.key, rrn.value, rrn.right);
                return new Node<K, V>(true, newLeft, rn.key, rn.value, newRight);
            }
            if (!rn.left.isEmpty() && (rln = (Node)rn.left).color()) {
                Node<K, V> newLeft = new Node<K, V>(false, left, key, value, rln.left);
                Node<K, V> newRight = new Node<K, V>(false, rln.right, rn.key, rn.value, rn.right);
                return new Node<K, V>(true, newLeft, rln.key, rln.value, newRight);
            }
        }
        return new Node<K, V>(color, left, key, value, right);
    }

    private static <K, V> Tuple2<? extends RedBlackTree<K, V>, Boolean> blackify(RedBlackTree<K, V> tree) {
        Node node;
        if (tree instanceof Node && (node = (Node)tree).color()) {
            return Tuple.of(node.color(false), false);
        }
        return Tuple.of(tree, true);
    }

    static <K, V> RedBlackTree<K, V> color(RedBlackTree<K, V> tree, boolean color) {
        return tree.isEmpty() ? tree : ((Node)tree).color(color);
    }

    static <K, V> Tuple2<? extends RedBlackTree<K, V>, Boolean> delete(RedBlackTree<K, V> tree, K key, Comparator<? super K> comparator) {
        if (tree.isEmpty()) {
            return Tuple.of(tree, false);
        }
        Node node = (Node)tree;
        int comparison = comparator.compare(key, node.key);
        if (comparison < 0) {
            Tuple2<RedBlackTree<K, V>, Boolean> deleted = Node.delete(node.left, key, comparator);
            RedBlackTree<? super K, V> l = deleted._1();
            boolean d = deleted._2();
            if (d) {
                return Node.unbalancedRight(node.color(), l, node.key, node.value, node.right);
            }
            Node<? super K, V> newNode = new Node<K, V>(node.color(), l, node.key, node.value, node.right);
            return Tuple.of(newNode, false);
        }
        if (comparison > 0) {
            Tuple2<RedBlackTree<K, V>, Boolean> deleted = Node.delete(node.right, key, comparator);
            RedBlackTree<? super K, V> r = deleted._1();
            boolean d = deleted._2();
            if (d) {
                return Node.unbalancedLeft(node.color(), node.left, node.key, node.value, r, Empty.empty());
            }
            Node<? super K, V> newNode = new Node<K, V>(node.color(), node.left, node.key, node.value, r);
            return Tuple.of(newNode, false);
        }
        if (node.right.isEmpty()) {
            if (!node.color()) {
                return Node.blackify(node.left);
            }
            return Tuple.of(node.left, false);
        }
        Node nodeRight = (Node)node.right;
        Tuple4<RedBlackTree<K, V>, Boolean, K, V> newRight = Node.deleteMin(nodeRight);
        RedBlackTree<K, V> r = newRight._1();
        boolean d = newRight._2();
        K m = newRight._3();
        V mv = newRight._4();
        if (d) {
            return Node.unbalancedLeft(node.color(), node.left, m, mv, r, Empty.empty());
        }
        Node<K, V> newNode = new Node<K, V>(node.color(), node.left, m, mv, r);
        return Tuple.of(newNode, false);
    }

    private static <K, V> Tuple4<? extends RedBlackTree<K, V>, Boolean, K, V> deleteMin(Node<K, V> node) {
        if (!node.color() && node.left().isEmpty() && node.right.isEmpty()) {
            return Tuple.of(Empty.empty(), true, node.getKey(), node.getValue());
        }
        if (!node.color() && node.left().isEmpty() && node.right().color()) {
            return Tuple.of(((Node)node.right()).color(false), false, node.getKey(), node.getValue());
        }
        if (node.color() && node.left().isEmpty()) {
            return Tuple.of(node.right(), false, node.getKey(), node.getValue());
        }
        Node nodeLeft = (Node)node.left;
        Tuple4<RedBlackTree<K, V>, Boolean, K, V> newNode = Node.deleteMin(nodeLeft);
        RedBlackTree<K, V> l = newNode._1();
        boolean deleted = newNode._2();
        K m = newNode._3();
        V mv = newNode._4();
        if (deleted) {
            Tuple2<Node<K, V>, Boolean> tD = Node.unbalancedRight(node.color(), l, node.key, node.value, node.right);
            return Tuple.of(tD._1(), tD._2(), m, mv);
        }
        Node<K, V> tD = new Node<K, V>(node.color(), l, node.key, node.value, node.right);
        return Tuple.of(tD, false, m, mv);
    }

    static <K, V> Node<K, V> insert(RedBlackTree<K, V> tree, K key, V value, Comparator<? super K> comparator) {
        if (tree.isEmpty()) {
            Empty empty = (Empty)tree;
            return new Node<K, V>(true, empty, key, value, empty);
        }
        Node<K, V> node = (Node<K, V>)tree;
        int comparison = comparator.compare(key, node.key);
        if (comparison < 0) {
            Node<? super K, V> newLeft = Node.insert(node.left, key, value, comparator);
            return newLeft == node.left ? node : Node.balanceLeft(node.color(), newLeft, node.key, node.value, node.right);
        }
        if (comparison > 0) {
            Node<? super K, V> newRight = Node.insert(node.right, key, value, comparator);
            return newRight == node.right ? node : Node.balanceRight(node.color(), node.left, node.key, node.value, newRight);
        }
        return Objects.equals(node.getValue(), value) ? node : new Node<K, V>(node.color(), node.left, key, value, node.right);
    }

    static <K, V> Node<K, V> maximum(Node<K, V> node) {
        Node curr = node;
        while (!curr.right.isEmpty()) {
            curr = (Node)curr.right;
        }
        return curr;
    }

    static <K, V> Node<K, V> minimum(Node<K, V> node) {
        Node curr = node;
        while (!curr.left.isEmpty()) {
            curr = (Node)curr.left;
        }
        return curr;
    }

    private static String toLispString(RedBlackTree<?, ?> tree) {
        if (tree.isEmpty()) {
            return "";
        }
        Node node = (Node)tree;
        String value = (node.color() ? (char)'R' : 'B') + ":" + String.valueOf(node.key) + (String)(node.value == null ? "" : "=" + String.valueOf(node.value));
        if (node.isLeaf()) {
            return value;
        }
        String left = node.left.isEmpty() ? "" : " " + Node.toLispString(node.left);
        String right = node.right.isEmpty() ? "" : " " + Node.toLispString(node.right);
        return "(" + value + "," + left + "," + right + ")";
    }

    private static <K, V> Tuple2<Node<K, V>, Boolean> unbalancedLeft(boolean color, RedBlackTree<K, V> left, K key, V value, RedBlackTree<K, V> right, Empty<K, V> empty) {
        if (!left.isEmpty()) {
            Node lrn;
            Node ln = (Node)left;
            if (!ln.color()) {
                Node<K, V> newNode = Node.balanceLeft(false, ln.color(true), key, value, right);
                return Tuple.of(newNode, !color);
            }
            if (!(color || ln.right.isEmpty() || (lrn = (Node)ln.right).color())) {
                Node<K, V> newRightNode = Node.balanceLeft(false, lrn.color(true), key, value, right);
                Node<K, V> newNode = new Node<K, V>(false, ln.left, ln.key, ln.value, newRightNode);
                return Tuple.of(newNode, false);
            }
        }
        throw new IllegalStateException("unbalancedLeft(" + color + ", " + String.valueOf(left) + ", " + String.valueOf(value) + ", " + String.valueOf(right) + ")");
    }

    private static <K, V> Tuple2<Node<K, V>, Boolean> unbalancedRight(boolean color, RedBlackTree<K, V> left, K key, V value, RedBlackTree<K, V> right) {
        if (!right.isEmpty()) {
            Node rln;
            Node rn = (Node)right;
            if (!rn.color()) {
                Node<K, V> newNode = Node.balanceRight(false, left, key, value, rn.color(true));
                return Tuple.of(newNode, !color);
            }
            if (!(color || rn.left.isEmpty() || (rln = (Node)rn.left).color())) {
                Node<K, V> newLeftNode = Node.balanceRight(false, left, key, value, rln.color(true));
                Node<K, V> newNode = new Node<K, V>(false, newLeftNode, rn.key, rn.value, rn.right);
                return Tuple.of(newNode, false);
            }
        }
        throw new IllegalStateException("unbalancedRight(" + color + ", " + String.valueOf(left) + ", " + String.valueOf(value) + ", " + String.valueOf(right) + ")");
    }

    @Override
    public @NonNull RedBlackTree<K, V> ceiling(K value, @NonNull Comparator<? super K> comparator) {
        int result = comparator.compare(value, this.key);
        if (result < 0) {
            return this.left.ceiling(value, comparator);
        }
        if (result > 0) {
            return this.right.ceiling(value, comparator).orElse(this);
        }
        return this;
    }

    @Override
    public boolean color() {
        return this.sizeAndColor < 0;
    }

    Node<K, V> color(boolean color) {
        return this.color() == color ? this : new Node<K, V>(color, this.left, this.key, this.value, this.right);
    }

    @Override
    public boolean contains(K key, Comparator<? super K> comparator) {
        int result = comparator.compare(key, this.key);
        if (result < 0) {
            return this.left.contains(key, comparator);
        }
        if (result > 0) {
            return this.right.contains(key, comparator);
        }
        return true;
    }

    @Override
    public  @Nullable Map.Entry<K, V> entryOrNull() {
        return this;
    }

    @Override
    public boolean equals(Object o) {
        Map.Entry e;
        return o instanceof Map.Entry && Objects.equals(this.key, (e = (Map.Entry)o).getKey()) && Objects.equals(this.value, e.getValue());
    }

    @Override
    public RedBlackTree<K, V> find(K key, Comparator<? super K> comparator) {
        int result = comparator.compare(key, this.key);
        if (result < 0) {
            return this.left.find(key, comparator);
        }
        if (result > 0) {
            return this.right.find(key, comparator);
        }
        return this;
    }

    @Override
    public @NonNull RedBlackTree<K, V> floor(K value, @NonNull Comparator<? super K> comparator) {
        int result = comparator.compare(value, this.key);
        if (result < 0) {
            return this.left.floor(value, comparator).orElse(this);
        }
        if (result > 0) {
            return this.right.floor(value, comparator);
        }
        return this;
    }

    @Override
    public K getKey() {
        return this.key;
    }

    @Override
    public V getValue() {
        return this.value;
    }

    @Override
    public int hashCode() {
        return (this.key == null ? 0 : this.key.hashCode()) ^ (this.value == null ? 0 : this.value.hashCode());
    }

    @Override
    public @NonNull RedBlackTree<K, V> higher(K value, @NonNull Comparator<? super K> comparator) {
        int result = comparator.compare(value, this.key);
        if (result < 0) {
            return this.left.higher(value, comparator);
        }
        if (result > 0) {
            return this.right.higher(value, comparator).orElse(this);
        }
        return this.right.higher(value, comparator);
    }

    @Override
    public boolean isEmpty() {
        return false;
    }

    private boolean isLeaf() {
        return this.left.isEmpty() && this.right.isEmpty();
    }

    @Override
    public boolean isRed() {
        return this.color();
    }

    @Override
    public @Nullable K keyOrNull() {
        return this.key;
    }

    @Override
    public RedBlackTree<K, V> left() {
        return this.left;
    }

    @Override
    public @NonNull RedBlackTree<K, V> lower(K value, @NonNull Comparator<? super K> comparator) {
        int result = comparator.compare(value, this.key);
        if (result < 0) {
            return this.left.lower(value, comparator).orElse(this);
        }
        if (result > 0) {
            return this.right.lower(value, comparator);
        }
        return this.left.lower(value, comparator);
    }

    @Override
    public <E> @Nullable E mapOrNull(@NonNull BiFunction<K, V, E> f) {
        return f.apply(this.key, this.value);
    }

    @Override
    public RedBlackTree<K, V> orElse(RedBlackTree<K, V> other) {
        return this;
    }

    @Override
    public @NonNull RedBlackTree<K, V> right() {
        return this.right;
    }

    @Override
    public V setValue(V value) {
        throw new UnsupportedOperationException();
    }

    @Override
    public int size() {
        return Math.abs(this.sizeAndColor);
    }

    @Override
    public String toLispString() {
        return this.isLeaf() ? "(" + (this.color() ? (char)'R' : 'B') + ":" + String.valueOf(this.key) + (String)(this.value == null ? "" : "=" + String.valueOf(this.value)) + ")" : Node.toLispString(this);
    }

    public String toString() {
        return String.valueOf(this.key) + "=" + String.valueOf(this.value);
    }

    @Override
    public @Nullable V valueOrNull() {
        return this.value;
    }
}

