/*
 * Decompiled with CFR 0.152.
 */
package org.jhotdraw8.icollection.impl.redblack;

import java.util.Collections;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.Set;
import org.jhotdraw8.annotation.NonNull;
import org.jhotdraw8.annotation.Nullable;
import org.jhotdraw8.icollection.readonly.ReadOnlyCollection;

public interface Option<T>
extends ReadOnlyCollection<T> {
    public static <T> Option<T> none() {
        return None.INSTANCE;
    }

    public static <T> Option<T> some(T value) {
        return new Some<T>(value);
    }

    public static <T> Option<T> of(T value) {
        return value == null ? Option.none() : Option.some(value);
    }

    @Override
    public boolean isEmpty();

    public @NonNull Option<T> orElse(@NonNull Option<? extends T> var1);

    default public @Nullable T getOrElse(@Nullable T other) {
        return this.isEmpty() ? other : this.get();
    }

    public @Nullable T get();

    public @Nullable T orNull();

    public @Nullable T orThrow();

    public record None<T>() implements Option<T>
    {
        private static final None<?> INSTANCE = new None();

        @Override
        public int size() {
            return 0;
        }

        @Override
        public boolean isEmpty() {
            return true;
        }

        @Override
        public boolean contains(Object o) {
            return false;
        }

        @Override
        public @NonNull Iterator<T> iterator() {
            return Collections.emptyIterator();
        }

        @Override
        public @NonNull Option<T> orElse(@NonNull Option<? extends T> other) {
            return other;
        }

        @Override
        public T get() {
            throw new NoSuchElementException();
        }

        @Override
        public @Nullable T orNull() {
            return null;
        }

        @Override
        public T orThrow() {
            throw new NoSuchElementException();
        }
    }

    public record Some<T>(T value) implements Option<T>
    {
        @Override
        public int size() {
            return 1;
        }

        @Override
        public boolean isEmpty() {
            return false;
        }

        @Override
        public boolean contains(Object o) {
            return Objects.equals(this.value, o);
        }

        @Override
        public @NonNull Iterator<T> iterator() {
            return Set.of(this.value).iterator();
        }

        @Override
        public @NonNull Option<T> orElse(@NonNull Option<? extends T> other) {
            return this;
        }

        @Override
        public T get() {
            return this.value;
        }

        @Override
        public T orNull() {
            return this.value;
        }

        @Override
        public T orThrow() {
            return this.value;
        }
    }
}

