/*
 * Decompiled with CFR 0.152.
 */
package org.jhotdraw8.icollection.impl.redblack;

import java.util.ArrayDeque;
import java.util.Comparator;
import java.util.Deque;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.function.BiFunction;
import org.jhotdraw8.annotation.NonNull;
import org.jhotdraw8.annotation.Nullable;
import org.jhotdraw8.icollection.VectorList;
import org.jhotdraw8.icollection.impl.redblack.Empty;
import org.jhotdraw8.icollection.impl.redblack.Node;

public interface RedBlackTree<K, V>
extends Iterable<Node<K, V>> {
    public String toLispString();

    public static <K, V> RedBlackTree<K, V> empty() {
        return Empty.empty();
    }

    public static <K, V> RedBlackTree<K, V> of(@NonNull Comparator<? super K> comparator, K key, V value) {
        Objects.requireNonNull(comparator, "comparator is null");
        Empty empty = Empty.empty();
        return new Node(false, empty, key, value, empty);
    }

    @SafeVarargs
    public static <K, V> RedBlackTree<K, V> of(@NonNull Comparator<? super K> comparator, K ... keys) {
        Objects.requireNonNull(comparator, "comparator is null");
        Objects.requireNonNull(keys, "values is null");
        RedBlackTree<? super K, Object> tree = RedBlackTree.empty();
        for (K key : keys) {
            tree = tree.insert((K)key, null, comparator);
        }
        return tree;
    }

    public static <K, V> RedBlackTree<K, V> ofAll(@NonNull Comparator<? super K> comparator, Iterable<? extends K> keys) {
        Objects.requireNonNull(comparator, "comparator is null");
        Objects.requireNonNull(keys, "values is null");
        RedBlackTree<? super K, Object> tree = RedBlackTree.empty();
        for (K key : keys) {
            tree = tree.insert((K)key, null, comparator);
        }
        return tree;
    }

    default public RedBlackTree<K, V> insert(K key, V value, Comparator<? super K> comparator) {
        return Node.insert(this, key, value, comparator).color(false);
    }

    public boolean color();

    public boolean contains(K var1, Comparator<? super K> var2);

    public boolean isRed();

    default public RedBlackTree<K, V> delete(K key, Comparator<? super K> comparator) {
        RedBlackTree tree = Node.delete(this, key, comparator)._1();
        return tree.size() == this.size() ? this : Node.color(tree, false);
    }

    public RedBlackTree<K, V> find(K var1, Comparator<? super K> var2);

    public boolean isEmpty();

    public RedBlackTree<K, V> left();

    default public @NonNull RedBlackTree<K, V> max() {
        return this.isEmpty() ? RedBlackTree.empty() : Node.maximum((Node)this);
    }

    default public @NonNull RedBlackTree<K, V> min() {
        return this.isEmpty() ? RedBlackTree.empty() : Node.minimum((Node)this);
    }

    public @NonNull RedBlackTree<K, V> right();

    public int size();

    default public boolean equals(@NonNull RedBlackTree<K, V> tree) {
        if (this == tree) {
            return true;
        }
        if (this.size() != tree.size()) {
            return false;
        }
        Iterator<Node<K, V>> ia = this.iterator();
        Iterator<Node<K, V>> ib = tree.iterator();
        int n = this.size();
        for (int i = 0; i < n; ++i) {
            Node<K, V> b;
            Node<K, V> a = ia.next();
            if (Objects.equals(a, b = ib.next())) continue;
            return false;
        }
        return true;
    }

    public K getKey();

    public V getValue();

    @Override
    default public @NonNull Iterator<Node<K, V>> iterator() {
        if (this.isEmpty()) {
            return VectorList.of().iterator();
        }
        final Node that = (Node)this;
        return new Iterator<Node<K, V>>(this){
            final Deque<Node<K, V>> stack;
            {
                this.stack = this.pushLeftChildren(new ArrayDeque(), that);
            }

            @Override
            public boolean hasNext() {
                return !this.stack.isEmpty();
            }

            @Override
            public Node<K, V> next() {
                if (!this.hasNext()) {
                    throw new NoSuchElementException();
                }
                Node node = this.stack.pop();
                if (!node.right.isEmpty()) {
                    this.pushLeftChildren(this.stack, (Node)node.right);
                }
                return node;
            }

            private Deque<Node<K, V>> pushLeftChildren(Deque<Node<K, V>> stack, Node<K, V> that2) {
                RedBlackTree tree = that2;
                while (!tree.isEmpty()) {
                    Node node = tree;
                    stack.push(node);
                    tree = node.left;
                }
                return stack;
            }
        };
    }

    default public Iterator<Node<K, V>> reverseIterator() {
        if (this.isEmpty()) {
            return VectorList.of().iterator();
        }
        final Node that = (Node)this;
        return new Iterator<Node<K, V>>(this){
            final Deque<Node<K, V>> stack;
            {
                this.stack = this.pushRightChildren(new ArrayDeque(), that);
            }

            @Override
            public boolean hasNext() {
                return !this.stack.isEmpty();
            }

            @Override
            public Node<K, V> next() {
                if (!this.hasNext()) {
                    throw new NoSuchElementException();
                }
                Node node = this.stack.pop();
                if (!node.left.isEmpty()) {
                    this.pushRightChildren(this.stack, (Node)node.left);
                }
                return node;
            }

            private Deque<Node<K, V>> pushRightChildren(Deque<Node<K, V>> stack, Node<K, V> that2) {
                RedBlackTree tree = that2;
                while (!tree.isEmpty()) {
                    Node node = tree;
                    stack.push(node);
                    tree = node.right;
                }
                return stack;
            }
        };
    }

    public @NonNull RedBlackTree<K, V> ceiling(K var1, @NonNull Comparator<? super K> var2);

    public @NonNull RedBlackTree<K, V> floor(K var1, @NonNull Comparator<? super K> var2);

    public @NonNull RedBlackTree<K, V> higher(K var1, @NonNull Comparator<? super K> var2);

    public @NonNull RedBlackTree<K, V> lower(K var1, @NonNull Comparator<? super K> var2);

    public RedBlackTree<K, V> orElse(RedBlackTree<K, V> var1);

    public @Nullable K keyOrNull();

    public @Nullable V valueOrNull();

    public  @Nullable Map.Entry<K, V> entryOrNull();

    public <E> @Nullable E mapOrNull(@NonNull BiFunction<K, V, E> var1);
}

