/*
 * Decompiled with CFR 0.152.
 */
package org.jhotdraw8.icollection.impl.vector;

import java.io.Serializable;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.SequencedCollection;
import java.util.Spliterator;
import java.util.Spliterators;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;
import org.jhotdraw8.annotation.NonNull;
import org.jhotdraw8.annotation.Nullable;
import org.jhotdraw8.icollection.impl.vector.ArrayType;
import org.jhotdraw8.icollection.impl.vector.LeafVisitor;
import org.jhotdraw8.icollection.impl.vector.NodeModifier;
import org.jhotdraw8.icollection.readonly.ReadOnlyCollection;
import org.jhotdraw8.icollection.readonly.ReadOnlySequencedCollection;

public class BitMappedTrie<T>
implements Serializable {
    static final int BRANCHING_BASE = 5;
    static final int BRANCHING_FACTOR = 32;
    static final int BRANCHING_MASK = 31;
    private static final long serialVersionUID = 1L;
    private static final @NonNull BitMappedTrie<?> EMPTY = new BitMappedTrie(ArrayType.obj(), ArrayType.obj().empty(), 0, 0, 0);
    public final @NonNull ArrayType<T> type;
    public final @NonNull Object array;
    public final int offset;
    public final int length;
    public final int depthShift;

    static int firstDigit(int num, int depthShift) {
        return num >> depthShift;
    }

    static int digit(int num, int depthShift) {
        return BitMappedTrie.lastDigit(BitMappedTrie.firstDigit(num, depthShift));
    }

    static int lastDigit(int num) {
        return num & 0x1F;
    }

    public static <T> @NonNull BitMappedTrie<T> empty() {
        return EMPTY;
    }

    protected BitMappedTrie(@NonNull ArrayType<T> type, @NonNull Object array, int offset, int length, int depthShift) {
        this.type = type;
        this.array = array;
        this.offset = offset;
        this.length = length;
        this.depthShift = depthShift;
    }

    private static int treeSize(int branchCount, int depthShift) {
        int fullBranchSize = 1 << depthShift;
        return branchCount * fullBranchSize;
    }

    public static <T> @NonNull BitMappedTrie<T> ofAll(@NonNull Object array) {
        ArrayType type = ArrayType.of(array);
        int size = type.lengthOf(array);
        return size == 0 ? BitMappedTrie.empty() : BitMappedTrie.ofAll(array, type, size);
    }

    private static <T> @NonNull BitMappedTrie<T> ofAll(@NonNull Object array, @NonNull ArrayType<T> type, int size) {
        int shift = 0;
        ArrayType<T> t = type;
        while (t.lengthOf(array) > 32) {
            array = t.grouped(array, 32);
            t = ArrayType.obj();
            shift += 5;
        }
        return new BitMappedTrie<T>(type, array, 0, size, shift);
    }

    private @NonNull BitMappedTrie<T> boxed() {
        return this.map(Function.identity());
    }

    protected @NonNull BitMappedTrie<T> prependAll(@NonNull Iterable<? extends T> iterable) {
        if (iterable instanceof SequencedCollection) {
            SequencedCollection s = (SequencedCollection)iterable;
            return this.prepend(s.reversed().iterator(), s.size());
        }
        if (iterable instanceof ReadOnlySequencedCollection) {
            ReadOnlySequencedCollection c = (ReadOnlySequencedCollection)iterable;
            return this.append(iterable.iterator(), c.size());
        }
        BitMappedTrie result = this;
        for (T t : iterable) {
            result = result.prepend(Collections.singleton(t).iterator(), 1);
        }
        return result;
    }

    public @NonNull BitMappedTrie<T> prepend(@NonNull Iterator<? extends T> iterator, int size) {
        BitMappedTrie<Iterator<? extends T>> result = this;
        while (size > 0) {
            Object array = result.array;
            int shift = result.depthShift;
            int offset = result.offset;
            if (result.isFullLeft()) {
                array = ArrayType.obj().copyUpdate(ArrayType.obj().empty(), 31, array);
                offset = BitMappedTrie.treeSize(31, shift += 5);
            }
            int index = offset - 1;
            int delta = Math.min(size, BitMappedTrie.lastDigit(index) + 1);
            size -= delta;
            array = result.modify(array, shift, index, NodeModifier.COPY_NODE, this.prependToLeaf(iterator));
            result = new BitMappedTrie<Iterator<? extends T>>(this.type, array, offset - delta, result.length + delta, shift);
        }
        return result;
    }

    public @NonNull BitMappedTrie<T> prepend(@Nullable T t) {
        int delta;
        BitMappedTrie<T> result = this;
        for (int size = 1; size > 0; size -= delta) {
            Object array = result.array;
            int shift = result.depthShift;
            int offset = result.offset;
            if (result.isFullLeft()) {
                array = ArrayType.obj().copyUpdate(ArrayType.obj().empty(), 31, array);
                offset = BitMappedTrie.treeSize(31, shift += 5);
            }
            int index = offset - 1;
            delta = Math.min(1, BitMappedTrie.lastDigit(index) + 1);
            array = result.modify(array, shift, index, NodeModifier.COPY_NODE, this.prependToLeaf(t));
            result = new BitMappedTrie<T>(this.type, array, offset - delta, result.length + delta, shift);
        }
        return result;
    }

    private boolean isFullLeft() {
        return this.offset == 0;
    }

    private @NonNull NodeModifier prependToLeaf(@NonNull Iterator<? extends T> iterator) {
        return (array, index) -> {
            Object copy = this.type.copy(array, 32);
            while (iterator.hasNext() && index >= 0) {
                this.type.setAt(copy, index--, iterator.next());
            }
            return copy;
        };
    }

    private @NonNull NodeModifier prependToLeaf(@Nullable T t) {
        return (array, index) -> {
            Object copy = this.type.copy(array, 32);
            this.type.setAt(copy, index, t);
            return copy;
        };
    }

    public @NonNull BitMappedTrie<T> appendAll(@NonNull Iterable<? extends T> iterable) {
        if (iterable instanceof Collection) {
            Collection c = (Collection)iterable;
            return this.append(iterable.iterator(), c.size());
        }
        if (iterable instanceof ReadOnlyCollection) {
            ReadOnlyCollection c = (ReadOnlyCollection)iterable;
            return this.append(iterable.iterator(), c.size());
        }
        BitMappedTrie<T> result = this;
        for (T t : iterable) {
            result = result.append(Collections.singleton(t).iterator(), 1);
        }
        return result;
    }

    public @NonNull BitMappedTrie<T> append(@NonNull Iterator<? extends T> iterator, int size) {
        BitMappedTrie<Iterator<? extends T>> result = this;
        while (size > 0) {
            Object array = result.array;
            int shift = result.depthShift;
            if (result.isFullRight()) {
                array = ArrayType.obj().asArray(array);
                shift += 5;
            }
            int index = this.offset + result.length;
            int leafSpace = BitMappedTrie.lastDigit(index);
            int delta = Math.min(size, 32 - leafSpace);
            size -= delta;
            array = result.modify(array, shift, index, NodeModifier.COPY_NODE, this.appendToLeaf(iterator, leafSpace + delta));
            result = new BitMappedTrie<Iterator<? extends T>>(this.type, array, this.offset, result.length + delta, shift);
        }
        return result;
    }

    public @NonNull BitMappedTrie<T> append(@Nullable T element) {
        int delta;
        BitMappedTrie<T> result = this;
        for (int size = 1; size > 0; size -= delta) {
            Object array = result.array;
            int shift = result.depthShift;
            if (result.isFullRight()) {
                array = ArrayType.obj().asArray(array);
                shift += 5;
            }
            int index = this.offset + result.length;
            int leafSpace = BitMappedTrie.lastDigit(index);
            delta = Math.min(size, 32 - leafSpace);
            array = result.modify(array, shift, index, NodeModifier.COPY_NODE, this.appendToLeaf(element, leafSpace + delta));
            result = new BitMappedTrie<T>(this.type, array, this.offset, result.length + delta, shift);
        }
        return result;
    }

    private boolean isFullRight() {
        return this.offset + this.length + 1 > BitMappedTrie.treeSize(32, this.depthShift);
    }

    private @NonNull NodeModifier appendToLeaf(@NonNull Iterator<? extends T> iterator, int leafSize) {
        return (array, index) -> {
            Object copy = this.type.copy(array, leafSize);
            while (iterator.hasNext() && index < leafSize) {
                this.type.setAt(copy, index++, iterator.next());
            }
            return copy;
        };
    }

    private @NonNull NodeModifier appendToLeaf(T element, int leafSize) {
        return (array, index) -> {
            Object copy = this.type.copy(array, leafSize);
            if (index < leafSize) {
                this.type.setAt(copy, index, element);
            }
            return copy;
        };
    }

    public @NonNull BitMappedTrie<T> update(int index, @Nullable T element) {
        try {
            Object root = this.modify(this.array, this.depthShift, this.offset + index, NodeModifier.COPY_NODE, this.updateLeafWith(this.type, element));
            return new BitMappedTrie<T>(this.type, root, this.offset, this.length, this.depthShift);
        }
        catch (ClassCastException ignored) {
            return this.boxed().update(index, element);
        }
    }

    private @NonNull NodeModifier updateLeafWith(ArrayType<T> type, @Nullable T element) {
        return (a, i) -> type.copyUpdate(a, i, element);
    }

    public @NonNull BitMappedTrie<T> drop(int n) {
        if (n <= 0) {
            return this;
        }
        if (n >= this.length) {
            return BitMappedTrie.empty();
        }
        int index = this.offset + n;
        Object root = this.arePointingToSameLeaf(0, n) ? this.array : this.modify(this.array, this.depthShift, index, ArrayType.obj()::copyDrop, NodeModifier.IDENTITY);
        return BitMappedTrie.collapsed(this.type, root, index, this.length - n, this.depthShift);
    }

    public @NonNull BitMappedTrie<T> take(int n) {
        if (n >= this.length) {
            return this;
        }
        if (n <= 0) {
            return BitMappedTrie.empty();
        }
        int index = n - 1;
        Object root = this.arePointingToSameLeaf(index, this.length - 1) ? this.array : this.modify(this.array, this.depthShift, this.offset + index, ArrayType.obj()::copyTake, NodeModifier.IDENTITY);
        return BitMappedTrie.collapsed(this.type, root, this.offset, n, this.depthShift);
    }

    private boolean arePointingToSameLeaf(int i, int j) {
        return BitMappedTrie.firstDigit(this.offset + i, 5) == BitMappedTrie.firstDigit(this.offset + j, 5);
    }

    private static <T> @NonNull BitMappedTrie<T> collapsed(@NonNull ArrayType<T> type, Object array, int offset, int length, int shift) {
        int skippedElements;
        while (shift > 0 && (skippedElements = ArrayType.obj().lengthOf(array) - 1) == BitMappedTrie.digit(offset, shift)) {
            array = ArrayType.obj().getAt(array, skippedElements);
            offset -= BitMappedTrie.treeSize(skippedElements, shift);
            shift -= 5;
        }
        return new BitMappedTrie<T>(type, array, offset, length, shift);
    }

    private @NonNull Object modify(@NonNull Object root, int depthShift, int index, @NonNull NodeModifier node, @NonNull NodeModifier leaf) {
        return depthShift == 0 ? leaf.apply(root, index) : this.modifyNonLeaf(root, depthShift, index, node, leaf);
    }

    private @NonNull Object modifyNonLeaf(@NonNull Object root, int depthShift, int index, @NonNull NodeModifier node, @NonNull NodeModifier leaf) {
        int previousIndex = BitMappedTrie.firstDigit(index, depthShift);
        Object array = root = node.apply(root, previousIndex);
        for (int shift = depthShift - 5; shift >= 5; shift -= 5) {
            int prev = previousIndex;
            previousIndex = BitMappedTrie.digit(index, shift);
            array = this.setNewNode(node, prev, array, previousIndex);
        }
        Object newLeaf = leaf.apply(ArrayType.obj().getAt(array, previousIndex), BitMappedTrie.lastDigit(index));
        ArrayType.obj().setAt(array, previousIndex, newLeaf);
        return root;
    }

    private @NonNull Object setNewNode(@NonNull NodeModifier node, int previousIndex, @NonNull Object array, int offset) {
        Object previous = ArrayType.obj().getAt(array, previousIndex);
        Object newNode = node.apply(previous, offset);
        ArrayType.obj().setAt(array, previousIndex, newNode);
        return newNode;
    }

    public @Nullable T get(int index) {
        Object leaf = this.getLeaf(index);
        int leafIndex = BitMappedTrie.lastDigit(this.offset + index);
        return this.type.getAt(leaf, leafIndex);
    }

    @Nullable Object getLeaf(int index) {
        if (this.depthShift == 0) {
            return this.array;
        }
        return this.getLeafGeneral(index);
    }

    private @Nullable Object getLeafGeneral(int index) {
        Object leaf = ArrayType.obj().getAt(this.array, BitMappedTrie.firstDigit(index += this.offset, this.depthShift));
        for (int shift = this.depthShift - 5; shift > 0; shift -= 5) {
            leaf = ArrayType.obj().getAt(leaf, BitMappedTrie.digit(index, shift));
        }
        return leaf;
    }

    public @NonNull Spliterator<T> spliterator(int fromIndex, int toIndex, int characteristics) {
        return new BitMappedTrieSpliterator(this, fromIndex, toIndex, characteristics);
    }

    public @NonNull Iterator<T> iterator(int fromIndex, int toIndex) {
        return new BitMappedTrieIterator(this, fromIndex, toIndex);
    }

    public @NonNull Iterator<T> iterator() {
        return new BitMappedTrieIterator(this, 0, this.length);
    }

    <T2> int visit(@NonNull LeafVisitor<T2> visitor) {
        int end;
        int globalIndex = 0;
        int start = BitMappedTrie.lastDigit(this.offset);
        for (int index = 0; index < this.length; index += end - start) {
            Object leaf = this.getLeaf(index);
            end = this.getMin(start, index, leaf);
            globalIndex = visitor.visit(globalIndex, leaf, start, end);
            start = 0;
        }
        return globalIndex;
    }

    private int getMin(int start, int index, @Nullable Object leaf) {
        return Math.min(this.type.lengthOf(leaf), start + this.length - index);
    }

    @NonNull BitMappedTrie<T> filter(@NonNull Predicate<? super T> predicate) {
        Object results = this.type.newInstance(this.length());
        int length = this.visit((index, leaf, start, end) -> this.filter(predicate, results, index, leaf, start, end));
        return this.length == length ? this : BitMappedTrie.ofAll(this.type.copyRange(results, 0, length));
    }

    private int filter(@NonNull Predicate<? super T> predicate, @NonNull Object results, int index, T leaf, int start, int end) {
        for (int i = start; i < end; ++i) {
            T value = this.type.getAt(leaf, i);
            if (!predicate.test(value)) continue;
            this.type.setAt(results, index++, value);
        }
        return index;
    }

    <U> @NonNull BitMappedTrie<U> map(@NonNull Function<? super T, ? extends U> mapper) {
        Object results = ArrayType.obj().newInstance(this.length);
        this.visit((index, leaf, start, end) -> this.map(mapper, results, index, leaf, start, end));
        return BitMappedTrie.ofAll(results);
    }

    private <U> int map(@NonNull Function<? super T, ? extends U> mapper, @NonNull Object results, int index, @Nullable T leaf, int start, int end) {
        for (int i = start; i < end; ++i) {
            ArrayType.obj().setAt(results, index++, mapper.apply(this.type.getAt(leaf, i)));
        }
        return index;
    }

    public int length() {
        return this.length;
    }

    public static class BitMappedTrieSpliterator<T>
    extends Spliterators.AbstractSpliterator<T> {
        private final int globalLength;
        private int globalIndex;
        private int index;
        private Object leaf;
        private int length;
        private final @NonNull BitMappedTrie<T> root;

        public BitMappedTrieSpliterator(@NonNull BitMappedTrie<T> root, int fromIndex, int toIndex, int characteristics) {
            super(root.length - fromIndex, characteristics);
            this.root = root;
            this.globalLength = toIndex;
            this.globalIndex = fromIndex;
            this.index = BitMappedTrie.lastDigit(root.offset + this.globalIndex);
            this.leaf = root.getLeaf(this.globalIndex);
            this.length = root.type.lengthOf(this.leaf);
        }

        @Override
        public boolean tryAdvance(@NonNull Consumer<? super T> action) {
            if (this.globalIndex >= this.globalLength) {
                return false;
            }
            if (this.index == this.length) {
                this.setCurrentArray();
            }
            Object current = this.root.type.getAt(this.leaf, this.index);
            ++this.index;
            ++this.globalIndex;
            action.accept(current);
            return true;
        }

        public void skip(int count) {
            this.globalIndex += count;
            this.index = BitMappedTrie.lastDigit(this.root.offset + this.globalIndex);
            this.leaf = this.root.getLeaf(this.globalIndex);
            this.length = this.root.type.lengthOf(this.leaf);
        }

        private void setCurrentArray() {
            this.index = 0;
            this.leaf = this.root.getLeaf(this.globalIndex);
            this.length = this.root.type.lengthOf(this.leaf);
        }
    }

    private static class BitMappedTrieIterator<T>
    implements Iterator<T> {
        private final int globalLength;
        private int globalIndex;
        private int index;
        private Object leaf;
        private int length;
        private final @NonNull BitMappedTrie<T> root;

        public BitMappedTrieIterator(@NonNull BitMappedTrie<T> root, int fromIndex, int toIndex) {
            this.root = root;
            this.globalLength = toIndex;
            this.globalIndex = fromIndex;
            this.index = BitMappedTrie.lastDigit(root.offset + fromIndex);
            this.leaf = root.getLeaf(this.globalIndex);
            this.length = root.type.lengthOf(this.leaf);
        }

        @Override
        public boolean hasNext() {
            return this.globalIndex < this.globalLength;
        }

        @Override
        public T next() {
            if (!this.hasNext()) {
                throw new NoSuchElementException("next() on empty iterator");
            }
            if (this.index == this.length) {
                this.setCurrentArray();
            }
            Object next = this.root.type.getAt(this.leaf, this.index);
            ++this.index;
            ++this.globalIndex;
            return next;
        }

        private void setCurrentArray() {
            this.index = 0;
            this.leaf = this.root.getLeaf(this.globalIndex);
            this.length = this.root.type.lengthOf(this.leaf);
        }
    }
}

