/*
 * Decompiled with CFR 0.152.
 */
package org.jhotdraw8.icollection.navigable;

import java.util.AbstractSet;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.NavigableSet;
import java.util.SortedSet;
import java.util.function.IntSupplier;
import org.jhotdraw8.annotation.NonNull;
import org.jhotdraw8.annotation.Nullable;
import org.jhotdraw8.icollection.navigable.SubsetNavigableSetView;

public class DescendingNavigableSetView<E>
extends AbstractSet<E>
implements NavigableSet<E> {
    private final @NonNull NavigableSet<E> src;
    private final @NonNull IntSupplier modCount;
    private final Comparator<? super E> reverseComparator;

    public DescendingNavigableSetView(@NonNull NavigableSet<E> src, @NonNull IntSupplier modCount) {
        this.src = src;
        this.modCount = modCount;
        this.reverseComparator = Collections.reverseOrder(src.comparator());
    }

    @Override
    public boolean add(E e) {
        return this.src.add(e);
    }

    @Override
    public @Nullable E ceiling(E e) {
        return this.src.floor(e);
    }

    @Override
    public void clear() {
        this.src.clear();
    }

    @Override
    public @Nullable Comparator<? super E> comparator() {
        return this.reverseComparator;
    }

    @Override
    public boolean contains(Object o) {
        return this.src.contains(o);
    }

    @Override
    public @NonNull Iterator<E> descendingIterator() {
        return this.src.iterator();
    }

    @Override
    public @NonNull NavigableSet<E> descendingSet() {
        return this.src;
    }

    @Override
    public E first() {
        return this.src.last();
    }

    @Override
    public @Nullable E floor(E e) {
        return this.src.ceiling(e);
    }

    @Override
    public @NonNull NavigableSet<E> headSet(E toElement, boolean inclusive) {
        return new SubsetNavigableSetView<Object>(this, this.modCount, true, null, true, false, toElement, inclusive, true);
    }

    @Override
    public @NonNull SortedSet<E> headSet(E toElement) {
        return this.headSet(toElement, false);
    }

    @Override
    public @Nullable E higher(E e) {
        return this.src.lower(e);
    }

    @Override
    public boolean isEmpty() {
        return this.src.isEmpty();
    }

    @Override
    public @NonNull Iterator<E> iterator() {
        return this.src.descendingIterator();
    }

    @Override
    public E last() {
        return this.src.first();
    }

    @Override
    public @Nullable E lower(E e) {
        return this.src.higher(e);
    }

    @Override
    public @Nullable E pollFirst() {
        return this.src.pollLast();
    }

    @Override
    public @Nullable E pollLast() {
        return this.src.pollFirst();
    }

    @Override
    public boolean remove(Object o) {
        return this.src.remove(o);
    }

    @Override
    public int size() {
        return this.src.size();
    }

    @Override
    public @NonNull NavigableSet<E> subSet(E fromElement, boolean fromInclusive, E toElement, boolean toInclusive) {
        return new SubsetNavigableSetView<E>(this, this.modCount, false, fromElement, fromInclusive, false, toElement, toInclusive, true);
    }

    @Override
    public @NonNull SortedSet<E> subSet(E fromElement, E toElement) {
        return this.subSet(fromElement, true, toElement, false);
    }

    @Override
    public @NonNull NavigableSet<E> tailSet(E fromElement, boolean inclusive) {
        return new SubsetNavigableSetView<Object>(this, this.modCount, false, fromElement, inclusive, true, null, true, true);
    }

    @Override
    public @NonNull SortedSet<E> tailSet(E fromElement) {
        return this.tailSet(fromElement, true);
    }
}

