/*
 * Decompiled with CFR 0.152.
 */
package org.jhotdraw8.icollection.navigable;

import java.util.AbstractMap;
import java.util.Comparator;
import java.util.ConcurrentModificationException;
import java.util.Iterator;
import java.util.Map;
import java.util.NavigableMap;
import java.util.NavigableSet;
import java.util.NoSuchElementException;
import java.util.Set;
import java.util.SortedMap;
import java.util.Spliterators;
import java.util.function.IntSupplier;
import org.jhotdraw8.annotation.NonNull;
import org.jhotdraw8.annotation.Nullable;
import org.jhotdraw8.icollection.MutableMapEntry;
import org.jhotdraw8.icollection.facade.NavigableSetFacade;
import org.jhotdraw8.icollection.facade.SetFacade;
import org.jhotdraw8.icollection.impl.IdentityObject;
import org.jhotdraw8.icollection.impl.iteration.FailFastIterator;
import org.jhotdraw8.icollection.impl.iteration.MappedIterator;
import org.jhotdraw8.icollection.navigable.DescendingNavigableMapView;
import org.jhotdraw8.icollection.readonly.ReadOnlyMap;

public class SubsetNavigableMapView<K, V>
extends AbstractMap<K, V>
implements ReadOnlyMap<K, V>,
NavigableMap<K, V> {
    private final @NonNull NavigableMap<K, V> src;
    private final @NonNull IntSupplier modCount;
    private final boolean fromStart;
    private final @Nullable K fromKey;
    private final boolean fromInclusive;
    private final boolean toEnd;
    private final @Nullable K toKey;
    private final boolean toInclusive;
    private final boolean nullFirst;

    public SubsetNavigableMapView(@NonNull NavigableMap<K, V> src, @NonNull IntSupplier modCount, boolean fromStart, @Nullable K fromKey, boolean fromInclusive, boolean toEnd, @Nullable K toKey, boolean toInclusive, boolean nullFirst) {
        this.src = src;
        this.modCount = modCount;
        this.fromStart = fromStart;
        this.fromKey = fromKey;
        this.fromInclusive = fromInclusive;
        this.toEnd = toEnd;
        this.toKey = toKey;
        this.toInclusive = toInclusive;
        this.nullFirst = nullFirst;
    }

    @Override
    public  @Nullable Map.Entry<K, V> ceilingEntry(K k) {
        if (this.tooLow(k)) {
            return this.lowestEntry();
        }
        Map.Entry<K, V> e = this.src.ceilingEntry(k);
        return e == null || this.tooHigh(e.getKey()) ? null : e;
    }

    @Override
    public @Nullable K ceilingKey(K key) {
        Map.Entry<K, V> e = this.ceilingEntry(key);
        return e == null ? null : (K)e.getKey();
    }

    @Override
    public void clear() {
        if (this.fromStart && this.toEnd) {
            this.src.clear();
        } else {
            for (Object o : this.keySet().toArray()) {
                this.src.remove(o);
            }
        }
    }

    @Override
    public @Nullable Comparator<? super K> comparator() {
        return this.src.comparator();
    }

    private int compare(@Nullable K a, @Nullable K b) {
        Comparator comparator = this.src.comparator();
        if (comparator == null) {
            if (a == null) {
                return b == null ? 0 : (this.nullFirst ? -1 : 1);
            }
            if (b == null) {
                return this.nullFirst ? 1 : -1;
            }
            return ((Comparable)a).compareTo(b);
        }
        return comparator.compare(a, b);
    }

    @Override
    public boolean containsKey(Object o) {
        return this.inRange(o) && this.src.containsKey(o);
    }

    private int countElements() {
        int size = 0;
        for (Map.Entry<K, V> e : this.entrySet()) {
            ++size;
        }
        return size;
    }

    @Override
    public NavigableSet<K> descendingKeySet() {
        return this.navigableKeySet().reversed();
    }

    @Override
    public @NonNull NavigableMap<K, V> descendingMap() {
        return new DescendingNavigableMapView(this, this.modCount);
    }

    @Override
    public @NonNull Set<Map.Entry<K, V>> entrySet() {
        return new SetFacade<Map.Entry<K, V>>(this::iterator, () -> Spliterators.spliterator(this.iterator(), (long)this.size(), 65), this::size, this::containsEntry, this::clear, null, this::removeEntry);
    }

    @Override
    public Map.Entry<K, V> firstEntry() {
        return this.src.firstEntry();
    }

    @Override
    public @Nullable K firstKey() {
        Map.Entry<K, V> entry = this.lowestEntry();
        if (entry == null) {
            throw new NoSuchElementException();
        }
        return entry.getKey();
    }

    @Override
    public  @Nullable Map.Entry<K, V> floorEntry(K k) {
        if (this.tooHigh(k)) {
            return this.highestEntry();
        }
         @Nullable Map.Entry<K, V> e = this.src.floorEntry(k);
        return e == null || this.tooLow(e.getKey()) ? null : e;
    }

    @Override
    public @Nullable K floorKey(K key) {
        Map.Entry<K, V> e = this.floorEntry(key);
        return e == null ? null : (K)e.getKey();
    }

    @Override
    public V getOrDefault(Object key, V defaultValue) {
        return super.getOrDefault(key, defaultValue);
    }

    @Override
    public @NonNull NavigableMap<K, V> headMap(K toKey, boolean inclusive) {
        if (!this.inRange(toKey, this.toInclusive)) {
            throw new IllegalArgumentException("toKey out of range");
        }
        return new SubsetNavigableMapView<K, V>(this.src, this.modCount, this.fromStart, this.fromKey, this.fromInclusive, false, toKey, this.toInclusive, this.nullFirst);
    }

    @Override
    public @NonNull SortedMap<K, V> headMap(K toKey) {
        return this.headMap(this.fromKey, false);
    }

    @Override
    public  @Nullable Map.Entry<K, V> higherEntry(K k) {
        if (this.tooLow(k)) {
            return this.lowestEntry();
        }
        Map.Entry<K, V> e = this.src.higherEntry(k);
        return e == null || this.tooHigh(e.getKey()) ? null : e;
    }

    @Override
    public @Nullable K higherKey(K key) {
        Map.Entry<K, V> e = this.higherEntry(key);
        return e == null ? null : (K)e.getKey();
    }

    private  @Nullable Map.Entry<K, V> highestEntry() {
        Map.Entry<K, V> e = this.toEnd ? this.src.lastEntry() : (this.toInclusive ? this.src.floorEntry(this.toKey) : this.src.lowerEntry(this.toKey));
        return e == null || this.tooLow(e.getKey()) ? null : e;
    }

    private boolean inClosedRange(K e) {
        return !(!this.fromStart && this.compare(e, this.fromKey) < 0 || !this.toEnd && this.compare(this.toKey, e) < 0);
    }

    private boolean inRange(Object key) {
        return !this.tooLow(key) && !this.tooHigh(key);
    }

    private boolean inRange(K e, boolean inclusive) {
        return inclusive ? this.inRange(e) : this.inClosedRange(e);
    }

    @Override
    public @NonNull Iterator<Map.Entry<K, V>> iterator() {
        return new FailFastIterator<Map.Entry<K, V>>(new MappedIterator<MutableMapEntry, Map.Entry>(new SubsetIterator(this.lowestKey(), this.iteratorHighFence(), this.src.entrySet().iterator()), e -> new MutableMapEntry<Object, Object>(this::iteratorPutIfPresent, e.getKey(), e.getValue())), this::iteratorRemove, this.modCount);
    }

    private @Nullable K iteratorHighFence() {
        return this.toEnd ? null : (K)(this.toInclusive ? this.src.higherEntry(this.toKey) : this.src.ceilingEntry(this.toKey)).getKey();
    }

    private @Nullable K iteratorLowFence() {
        return this.fromStart ? null : (K)(this.fromInclusive ? this.src.lowerEntry(this.fromKey) : this.src.floorEntry(this.fromKey)).getKey();
    }

    private void iteratorPutIfPresent(@Nullable K k, @Nullable V v) {
        if (this.containsKey(k)) {
            this.put(k, v);
        }
    }

    private void iteratorRemove(Map.Entry<K, V> entry) {
        this.remove(entry.getKey());
    }

    @Override
    public Map.Entry<K, V> lastEntry() {
        return this.highestEntry();
    }

    @Override
    public @Nullable K lastKey() {
        Map.Entry<K, V> entry = this.highestEntry();
        if (entry == null) {
            throw new NoSuchElementException();
        }
        return entry.getKey();
    }

    @Override
    public  @Nullable Map.Entry<K, V> lowerEntry(K k) {
        if (this.tooHigh(k)) {
            return this.highestEntry();
        }
         @Nullable Map.Entry<K, V> e = this.src.lowerEntry(k);
        return e == null || this.tooLow(e.getKey()) ? null : e;
    }

    @Override
    public @Nullable K lowerKey(K key) {
        Map.Entry<K, V> e = this.lowerEntry(key);
        return e == null ? null : (K)e.getKey();
    }

    private  @Nullable Map.Entry<K, V> lowestEntry() {
        Map.Entry<K, V> e = this.fromStart ? this.src.firstEntry() : (this.fromInclusive ? this.src.ceilingEntry(this.fromKey) : this.src.higherEntry(this.fromKey));
        return e == null || this.tooHigh(e.getKey()) ? null : e;
    }

    private @Nullable K lowestKey() {
        Map.Entry<K, V> entry = this.lowestEntry();
        return entry == null ? null : (K)entry.getKey();
    }

    @Override
    public NavigableSet<K> navigableKeySet() {
        return NavigableSetFacade.createKeySet(this);
    }

    @Override
    public  @Nullable Map.Entry<K, V> pollFirstEntry() {
        return this.lowestEntry();
    }

    @Override
    public  @Nullable Map.Entry<K, V> pollLastEntry() {
        return this.highestEntry();
    }

    @Override
    public V put(K e, V v) {
        if (!this.inRange(e)) {
            throw new IllegalArgumentException("element out of range");
        }
        return this.src.put(e, v);
    }

    @Override
    public @Nullable V remove(Object o) {
        return this.inRange(o) ? (V)this.src.remove(o) : null;
    }

    private boolean removeEntry(@Nullable Object o) {
        if (this.containsEntry(o)) {
            assert (o != null);
            this.remove(((Map.Entry)o).getKey());
            return true;
        }
        return false;
    }

    @Override
    public int size() {
        return this.fromStart && this.toEnd ? this.src.size() : this.countElements();
    }

    @Override
    public @NonNull NavigableMap<K, V> subMap(K fromKey, boolean fromInclusive, K toKey, boolean toInclusive) {
        if (!this.inRange(fromKey, fromInclusive)) {
            throw new IllegalArgumentException("fromKey out of range");
        }
        if (!this.inRange(toKey, toInclusive)) {
            throw new IllegalArgumentException("toKey out of range");
        }
        return new SubsetNavigableMapView<K, V>(this.src, this.modCount, false, fromKey, fromInclusive, false, toKey, toInclusive, this.nullFirst);
    }

    @Override
    public @NonNull SortedMap<K, V> subMap(K fromKey, K toKey) {
        return this.subMap(fromKey, true, toKey, false);
    }

    @Override
    public @NonNull NavigableMap<K, V> tailMap(K fromKey, boolean inclusive) {
        if (!this.inRange(fromKey, this.fromInclusive)) {
            throw new IllegalArgumentException("fromKey out of range");
        }
        return new SubsetNavigableMapView<K, V>(this.src, this.modCount, false, fromKey, this.fromInclusive, this.toEnd, this.toKey, this.toInclusive, this.nullFirst);
    }

    @Override
    public @NonNull SortedMap<K, V> tailMap(K fromKey) {
        return this.tailMap(fromKey, true);
    }

    private boolean tooHigh(@Nullable K key) {
        int c;
        return !this.toEnd && ((c = this.compare(key, this.toKey)) > 0 || c == 0 && !this.toInclusive);
    }

    private boolean tooLow(@Nullable K key) {
        int c;
        return !this.fromStart && ((c = this.compare(key, this.fromKey)) < 0 || c == 0 && !this.fromInclusive);
    }

    private class SubsetIterator
    implements Iterator<Map.Entry<K, V>> {
        final Object fenceKey;
        Map.Entry<K, V> lastReturned;
        Map.Entry<K, V> next;
        boolean hasNext;
        int expectedModCount;
        Iterator<Map.Entry<K, V>> srcIterator;

        SubsetIterator(@Nullable K first, K fence, Iterator<Map.Entry<K, V>> srcIterator) {
            this.expectedModCount = SubsetNavigableMapView.this.modCount.getAsInt();
            this.lastReturned = null;
            if (first == null) {
                this.hasNext = srcIterator.hasNext();
                this.next = srcIterator.next();
            } else {
                while (srcIterator.hasNext()) {
                    this.next = srcIterator.next();
                    if (this.next != first) continue;
                    this.hasNext = true;
                    break;
                }
            }
            Object object = this.fenceKey = fence == null ? new IdentityObject() : fence;
            if (this.next == this.fenceKey) {
                this.hasNext = false;
            }
        }

        @Override
        public final boolean hasNext() {
            return this.hasNext;
        }

        @Override
        public final Map.Entry<K, V> next() {
            if (!this.hasNext) {
                throw new NoSuchElementException();
            }
            if (SubsetNavigableMapView.this.modCount.getAsInt() != this.expectedModCount) {
                throw new ConcurrentModificationException();
            }
            Map.Entry e = this.next;
            this.hasNext = this.srcIterator.hasNext();
            if (this.hasNext) {
                this.next = this.srcIterator.next();
                if (this.next == this.fenceKey) {
                    this.hasNext = false;
                }
            }
            this.lastReturned = e;
            return e;
        }

        @Override
        public void remove() {
            if (this.lastReturned == null) {
                throw new IllegalStateException();
            }
            if (SubsetNavigableMapView.this.modCount.getAsInt() != this.expectedModCount) {
                throw new ConcurrentModificationException();
            }
            SubsetNavigableMapView.this.src.remove(this.lastReturned.getKey());
            this.lastReturned = null;
            this.expectedModCount = SubsetNavigableMapView.this.modCount.getAsInt();
        }
    }
}

