/*
 * Decompiled with CFR 0.152.
 */
package org.jhotdraw8.icollection.readonly;

import java.util.Arrays;
import java.util.Collection;
import java.util.ConcurrentModificationException;
import java.util.Iterator;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import org.jhotdraw8.annotation.NonNull;
import org.jhotdraw8.icollection.facade.CollectionFacade;

public interface ReadOnlyCollection<E>
extends Iterable<E> {
    public int size();

    default public boolean isEmpty() {
        return this.size() == 0;
    }

    default public Object @NonNull [] toArray() {
        return this.toArray(new Object[this.size()]);
    }

    default public <T> @NonNull T @NonNull [] toArray(@NonNull T @NonNull [] a) {
        int size = this.size();
        T[] r = a.length >= size ? a : Arrays.copyOf(a, size, a.getClass());
        Iterator<E> it = this.iterator();
        for (int i = 0; i < r.length; ++i) {
            if (!it.hasNext()) {
                throw new ConcurrentModificationException("fewer elements than expected. expected=" + size);
            }
            E t = it.next();
            r[i] = t;
        }
        if (it.hasNext()) {
            throw new ConcurrentModificationException("more elements than expected. expected=" + size);
        }
        return r;
    }

    default public Stream<E> stream() {
        return StreamSupport.stream(this.spliterator(), false);
    }

    public boolean contains(Object var1);

    @Override
    public @NonNull Iterator<E> iterator();

    default public boolean containsAll(@NonNull Iterable<?> c) {
        for (Object e : c) {
            if (this.contains(e)) continue;
            return false;
        }
        return true;
    }

    default public @NonNull Collection<E> asCollection() {
        return new CollectionFacade(this);
    }

    public static <E> @NonNull String iterableToString(@NonNull Iterable<E> c) {
        Iterator<E> it = c.iterator();
        if (!it.hasNext()) {
            return "[]";
        }
        StringBuilder sb = new StringBuilder();
        sb.append('[');
        while (true) {
            E e;
            sb.append((Object)((e = it.next()) == c ? "(this Collection)" : e));
            if (!it.hasNext()) {
                return sb.append(']').toString();
            }
            sb.append(',').append(' ');
        }
    }

    default public int characteristics() {
        return 64;
    }
}

