/*
 * Decompiled with CFR 0.152.
 */
package org.jhotdraw8.icollection.serialization;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import org.jhotdraw8.annotation.NonNull;

public abstract class SetSerializationProxy<E>
implements Serializable {
    private static final long serialVersionUID = 0L;
    private final transient Set<E> serialized;
    protected transient List<E> deserializedElements;

    protected SetSerializationProxy(@NonNull Set<E> serialized) {
        this.serialized = serialized;
    }

    private void writeObject(@NonNull ObjectOutputStream s) throws IOException {
        s.writeInt(this.serialized.size());
        for (E e : this.serialized) {
            s.writeObject(e);
        }
    }

    private void readObject(@NonNull ObjectInputStream s) throws IOException, ClassNotFoundException {
        int n = s.readInt();
        this.deserializedElements = new ArrayList(n);
        for (int i = 0; i < n; ++i) {
            Object e = s.readObject();
            this.deserializedElements.add(e);
        }
    }

    protected abstract @NonNull Object readResolve();
}

