/*
 * Decompiled with CFR 0.152.
 */
package org.jhotdraw8.icollection.serialization;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.SortedMap;
import org.jhotdraw8.annotation.NonNull;

public abstract class SortedMapSerializationProxy<K, V>
implements Serializable {
    private final transient SortedMap<K, V> serialized;
    protected transient List<Map.Entry<K, V>> deserializedEntries;
    protected transient Comparator<? super K> deserializedComparator;
    private static final long serialVersionUID = 0L;

    protected SortedMapSerializationProxy(SortedMap<K, V> serialized) {
        this.serialized = serialized;
    }

    private void writeObject(@NonNull ObjectOutputStream s) throws IOException {
        s.writeObject(this.serialized.comparator());
        s.writeInt(this.serialized.size());
        for (Map.Entry<K, V> entry : this.serialized.entrySet()) {
            s.writeObject(entry.getKey());
            s.writeObject(entry.getValue());
        }
    }

    private void readObject(@NonNull ObjectInputStream s) throws IOException, ClassNotFoundException {
        this.deserializedComparator = (Comparator)s.readObject();
        int n = s.readInt();
        this.deserializedEntries = new ArrayList<Map.Entry<K, V>>(n);
        for (int i = 0; i < n; ++i) {
            Object key = s.readObject();
            Object value = s.readObject();
            this.deserializedEntries.add(new AbstractMap.SimpleImmutableEntry<Object, Object>(key, value));
        }
    }

    protected abstract @NonNull Object readResolve();
}

