/*
 * Decompiled with CFR 0.152.
 */
package org.jhotdraw8.icollection.serialization;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.SortedSet;
import org.jhotdraw8.annotation.NonNull;

public abstract class SortedSetSerializationProxy<E>
implements Serializable {
    private static final long serialVersionUID = 0L;
    private final transient SortedSet<E> serialized;
    protected transient List<E> deserializedElements;
    protected transient Comparator<E> deserializedComparator;

    protected SortedSetSerializationProxy(@NonNull SortedSet<E> serialized) {
        this.serialized = serialized;
    }

    private void writeObject(@NonNull ObjectOutputStream s) throws IOException {
        s.writeObject(this.serialized.comparator());
        s.writeInt(this.serialized.size());
        for (Object e : this.serialized) {
            s.writeObject(e);
        }
    }

    private void readObject(@NonNull ObjectInputStream s) throws IOException, ClassNotFoundException {
        this.deserializedComparator = (Comparator)s.readObject();
        int n = s.readInt();
        this.deserializedElements = new ArrayList(n);
        for (int i = 0; i < n; ++i) {
            Object e = s.readObject();
            this.deserializedElements.add(e);
        }
    }

    protected abstract @NonNull Object readResolve();
}

