/*
 * Decompiled with CFR 0.152.
 */
package org.jhotdraw8.icollection;

import java.util.Arrays;
import java.util.Objects;
import org.jhotdraw8.annotation.NonNull;
import org.jhotdraw8.icollection.immutable.ImmutableAddOnlySet;

public abstract class ChampAddOnlySet<E>
implements ImmutableAddOnlySet<E> {
    private static final int ENTRY_LENGTH = 1;
    private static final int HASH_CODE_LENGTH = 32;
    private static final int BIT_PARTITION_SIZE = 5;
    private static final int BIT_PARTITION_MASK = 31;

    ChampAddOnlySet() {
    }

    private static int bitpos(int mask) {
        return 1 << mask;
    }

    private static int mask(int keyHash, int shift) {
        return keyHash >>> shift & 0x1F;
    }

    private static <K> @NonNull ChampAddOnlySet<K> mergeTwoKeyValPairs(@NonNull K key0, int keyHash0, @NonNull K key1, int keyHash1, int shift) {
        int mask1;
        assert (!key0.equals(key1));
        if (shift >= 32) {
            HashCollisionNode<Object> unchecked = new HashCollisionNode<Object>(keyHash0, key0, key1);
            return unchecked;
        }
        int mask0 = ChampAddOnlySet.mask(keyHash0, shift);
        if (mask0 != (mask1 = ChampAddOnlySet.mask(keyHash1, shift))) {
            int dataMap = ChampAddOnlySet.bitpos(mask0) | ChampAddOnlySet.bitpos(mask1);
            if (mask0 < mask1) {
                return new BitmapIndexedNode(0, dataMap, key0, key1);
            }
            return new BitmapIndexedNode(0, dataMap, key1, key0);
        }
        ChampAddOnlySet<K> node = ChampAddOnlySet.mergeTwoKeyValPairs(key0, keyHash0, key1, keyHash1, shift + 5);
        int nodeMap = ChampAddOnlySet.bitpos(mask0);
        return new BitmapIndexedNode(nodeMap, 0, node);
    }

    public static <E> @NonNull ChampAddOnlySet<E> of() {
        return BitmapIndexedNode.EMPTY_NODE;
    }

    @SafeVarargs
    public static <E> @NonNull ChampAddOnlySet<E> of(E ... elements) {
        ImmutableAddOnlySet<Object> set = BitmapIndexedNode.EMPTY_NODE;
        for (E e : elements) {
            set = set.add((Object)e);
        }
        return set;
    }

    @Override
    public @NonNull ChampAddOnlySet<E> add(@NonNull E key) {
        return this.updated(key, key.hashCode(), 0);
    }

    abstract @NonNull ChampAddOnlySet<E> updated(@NonNull E var1, int var2, int var3);

    private static final class HashCollisionNode<K>
    extends ChampAddOnlySet<K> {
        private final @NonNull K[] keys;
        private final int hash;

        @SafeVarargs
        HashCollisionNode(int hash, K ... keys) {
            this.keys = keys;
            this.hash = hash;
        }

        @Override
        @NonNull ChampAddOnlySet<K> updated(@NonNull K key, int keyHash, int shift) {
            assert (this.hash == keyHash);
            for (K k : this.keys) {
                if (!Objects.equals(k, key)) continue;
                return this;
            }
            K[] keysNew = Arrays.copyOf(this.keys, this.keys.length + 1);
            keysNew[this.keys.length] = key;
            return new HashCollisionNode<K>(keyHash, keysNew);
        }
    }

    private static final class BitmapIndexedNode<K>
    extends ChampAddOnlySet<K> {
        private static final @NonNull ChampAddOnlySet<?> EMPTY_NODE = new BitmapIndexedNode(0, 0, new Object[0]);
        final @NonNull Object[] nodes;
        private final int nodeMap;
        private final int dataMap;

        BitmapIndexedNode(int nodeMap, int dataMap, Object ... nodes) {
            this.nodeMap = nodeMap;
            this.dataMap = dataMap;
            this.nodes = nodes;
        }

        @NonNull ChampAddOnlySet<K> copyAndInsertValue(int bitpos, @NonNull K key) {
            int idx = 1 * this.dataIndex(bitpos);
            Object[] src = this.nodes;
            Object[] dst = new Object[src.length + 1];
            System.arraycopy(src, 0, dst, 0, idx);
            System.arraycopy(src, idx, dst, idx + 1, src.length - idx);
            dst[idx] = key;
            return new BitmapIndexedNode<K>(this.nodeMap, this.dataMap | bitpos, dst);
        }

        @NonNull ChampAddOnlySet<K> copyAndMigrateFromInlineToNode(int bitpos, @NonNull ChampAddOnlySet<K> node) {
            int idxOld = 1 * this.dataIndex(bitpos);
            int idxNew = this.nodes.length - 1 - this.nodeIndex(bitpos);
            assert (idxOld <= idxNew);
            Object[] src = this.nodes;
            Object[] dst = new Object[src.length - 1 + 1];
            System.arraycopy(src, 0, dst, 0, idxOld);
            System.arraycopy(src, idxOld + 1, dst, idxOld, idxNew - idxOld);
            System.arraycopy(src, idxNew + 1, dst, idxNew + 1, src.length - idxNew - 1);
            dst[idxNew] = node;
            return new BitmapIndexedNode<K>(this.nodeMap | bitpos, this.dataMap ^ bitpos, dst);
        }

        @NonNull ChampAddOnlySet<K> copyAndSetNode(int bitpos, @NonNull ChampAddOnlySet<K> newNode) {
            int nodeIndex = this.nodeIndex(bitpos);
            int idx = this.nodes.length - 1 - nodeIndex;
            Object[] src = this.nodes;
            Object[] dst = new Object[src.length];
            System.arraycopy(src, 0, dst, 0, src.length);
            dst[idx] = newNode;
            return new BitmapIndexedNode<K>(this.nodeMap, this.dataMap, dst);
        }

        int dataIndex(int bitpos) {
            return Integer.bitCount(this.dataMap & bitpos - 1);
        }

        @NonNull K getKey(int index) {
            return (K)this.nodes[1 * index];
        }

        @NonNull ChampAddOnlySet<K> getNode(int index) {
            return (ChampAddOnlySet)this.nodes[this.nodes.length - 1 - index];
        }

        @NonNull ChampAddOnlySet<K> nodeAt(int bitpos) {
            return this.getNode(this.nodeIndex(bitpos));
        }

        int nodeIndex(int bitpos) {
            return Integer.bitCount(this.nodeMap & bitpos - 1);
        }

        @Override
        @NonNull ChampAddOnlySet<K> updated(@NonNull K key, int keyHash, int shift) {
            int mask = ChampAddOnlySet.mask(keyHash, shift);
            int bitpos = ChampAddOnlySet.bitpos(mask);
            if ((this.dataMap & bitpos) != 0) {
                int dataIndex = this.dataIndex(bitpos);
                K currentKey = this.getKey(dataIndex);
                if (Objects.equals(currentKey, key)) {
                    return this;
                }
                ChampAddOnlySet<K> subNodeNew = ChampAddOnlySet.mergeTwoKeyValPairs(currentKey, currentKey.hashCode(), key, keyHash, shift + 5);
                return this.copyAndMigrateFromInlineToNode(bitpos, subNodeNew);
            }
            if ((this.nodeMap & bitpos) != 0) {
                ChampAddOnlySet<K> subNodeNew;
                ChampAddOnlySet<K> subNode = this.nodeAt(bitpos);
                if (subNode != (subNodeNew = subNode.updated(key, keyHash, shift + 5))) {
                    return this.copyAndSetNode(bitpos, subNodeNew);
                }
                return this;
            }
            return this.copyAndInsertValue(bitpos, key);
        }
    }
}

