/*
 * Decompiled with CFR 0.152.
 */
package org.jhotdraw8.icollection;

import java.io.ObjectStreamException;
import java.io.Serializable;
import java.util.AbstractMap;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.Map;
import java.util.NavigableMap;
import java.util.NavigableSet;
import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.Set;
import java.util.SortedMap;
import java.util.Spliterator;
import java.util.Spliterators;
import org.jhotdraw8.annotation.NonNull;
import org.jhotdraw8.annotation.Nullable;
import org.jhotdraw8.icollection.MutableMapEntry;
import org.jhotdraw8.icollection.NaturalComparator;
import org.jhotdraw8.icollection.RedBlackMap;
import org.jhotdraw8.icollection.facade.CollectionFacade;
import org.jhotdraw8.icollection.facade.NavigableSetFacade;
import org.jhotdraw8.icollection.facade.ReadOnlySequencedMapFacade;
import org.jhotdraw8.icollection.facade.SetFacade;
import org.jhotdraw8.icollection.impl.iteration.FailFastIterator;
import org.jhotdraw8.icollection.impl.iteration.FailFastSpliterator;
import org.jhotdraw8.icollection.impl.iteration.MappedIterator;
import org.jhotdraw8.icollection.impl.iteration.MappedSpliterator;
import org.jhotdraw8.icollection.impl.redblack.Node;
import org.jhotdraw8.icollection.impl.redblack.RedBlackTree;
import org.jhotdraw8.icollection.navigable.DescendingNavigableMapView;
import org.jhotdraw8.icollection.navigable.SubsetNavigableMapView;
import org.jhotdraw8.icollection.readonly.ReadOnlyNavigableMap;
import org.jhotdraw8.icollection.readonly.ReadOnlySequencedMap;
import org.jhotdraw8.icollection.serialization.SortedMapSerializationProxy;

public class MutableRedBlackMap<K, V>
extends AbstractMap<K, V>
implements NavigableMap<K, V>,
ReadOnlyNavigableMap<K, V>,
Cloneable,
Serializable {
    private static final long serialVersionUID = 0L;
    transient @NonNull RedBlackTree<K, V> root;
    final @NonNull Comparator<? super K> comparator;
    private transient int modCount;

    @Override
    public MutableRedBlackMap<K, V> clone() {
        try {
            return (MutableRedBlackMap)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new AssertionError();
        }
    }

    int getModCount() {
        return this.modCount;
    }

    public MutableRedBlackMap() {
        this.root = RedBlackTree.empty();
        this.comparator = NaturalComparator.instance();
    }

    public MutableRedBlackMap(@Nullable Comparator<? super K> comparator) {
        this.root = RedBlackTree.empty();
        this.comparator = comparator == null ? NaturalComparator.instance() : comparator;
    }

    public MutableRedBlackMap(@NonNull Map<? extends K, ? extends V> m) {
        MutableRedBlackMap r;
        this.comparator = NaturalComparator.instance();
        if (m instanceof MutableRedBlackMap && (r = (MutableRedBlackMap)m).comparator() == null) {
            MutableRedBlackMap that = (MutableRedBlackMap)m;
            this.root = that.root;
        } else {
            this.root = RedBlackTree.empty();
            this.putAll(m);
        }
    }

    public MutableRedBlackMap(@NonNull SortedMap<? extends K, ? extends V> m) {
        MutableRedBlackMap r;
        Comparator<Object> comparator = this.comparator = m.comparator() == null ? NaturalComparator.instance() : m.comparator();
        if (m instanceof MutableRedBlackMap && (r = (MutableRedBlackMap)m).comparator() == null) {
            MutableRedBlackMap that = (MutableRedBlackMap)m;
            this.root = that.root;
        } else {
            this.root = RedBlackTree.empty();
            this.putAll(m);
        }
    }

    public MutableRedBlackMap(@NonNull Iterable<? extends Map.Entry<? extends K, ? extends V>> m) {
        this.comparator = NaturalComparator.instance();
        if (m instanceof RedBlackMap) {
            RedBlackMap that = (RedBlackMap)m;
            this.root = that.root;
        } else {
            this.root = RedBlackTree.empty();
            for (Map.Entry<K, V> e : m) {
                this.put(e.getKey(), e.getValue());
            }
        }
    }

    MutableRedBlackMap(@NonNull RedBlackTree<K, V> root, @NonNull Comparator<? super K> comparator) {
        this.root = root;
        this.comparator = comparator;
    }

    @Override
    public Map.Entry<K, V> lowerEntry(K key) {
        return this.root.lower((K)key, this.comparator).entryOrNull();
    }

    @Override
    public K lowerKey(K key) {
        return this.root.lower((K)key, this.comparator).keyOrNull();
    }

    @Override
    public Map.Entry<K, V> floorEntry(K key) {
        return this.root.floor((K)key, this.comparator).entryOrNull();
    }

    @Override
    public K floorKey(K key) {
        return this.root.floor((K)key, this.comparator).keyOrNull();
    }

    @Override
    public Map.Entry<K, V> ceilingEntry(K key) {
        return this.root.ceiling((K)key, this.comparator).entryOrNull();
    }

    @Override
    public K ceilingKey(K key) {
        return this.root.ceiling((K)key, this.comparator).keyOrNull();
    }

    @Override
    public Map.Entry<K, V> higherEntry(K key) {
        return this.root.higher((K)key, this.comparator).entryOrNull();
    }

    @Override
    public K higherKey(K key) {
        return this.root.higher((K)key, this.comparator).keyOrNull();
    }

    @Override
    public @NonNull ReadOnlySequencedMap<K, V> readOnlyReversed() {
        return new ReadOnlySequencedMapFacade<Object, Object>(this::iterator, this::reverseIterator, this::size, this::containsKey, this::get, this::lastEntry, this::firstEntry, 81, null);
    }

    @Override
    public @Nullable Map.Entry<K, V> firstEntry() {
        return this.root.min().entryOrNull();
    }

    @Override
    public @Nullable Map.Entry<K, V> lastEntry() {
        return this.root.max().entryOrNull();
    }

    @Override
    public @Nullable Map.Entry<K, V> pollFirstEntry() {
        RedBlackTree<K, V> min = this.root.min();
        if (!min.isEmpty()) {
            this.root = this.root.delete((K)min.getKey(), this.comparator);
        }
        return min.entryOrNull();
    }

    @Override
    public @Nullable Map.Entry<K, V> pollLastEntry() {
        RedBlackTree<K, V> max = this.root.max();
        if (max.isEmpty()) {
            this.root = this.root.delete((K)max.getKey(), this.comparator);
        }
        return max.entryOrNull();
    }

    @Override
    public NavigableMap<K, V> descendingMap() {
        return new DescendingNavigableMapView(this, this::getModCount);
    }

    @Override
    public NavigableSet<K> navigableKeySet() {
        return NavigableSetFacade.createKeySet(this);
    }

    @Override
    public NavigableSet<K> descendingKeySet() {
        return this.navigableKeySet().reversed();
    }

    @Override
    public NavigableMap<K, V> subMap(K fromKey, boolean fromInclusive, K toKey, boolean toInclusive) {
        return new SubsetNavigableMapView(this, this::getModCount, false, fromKey, fromInclusive, false, toKey, toInclusive, true);
    }

    @Override
    public NavigableMap<K, V> headMap(K toKey, boolean inclusive) {
        return new SubsetNavigableMapView(this, this::getModCount, true, null, true, false, toKey, inclusive, true);
    }

    @Override
    public NavigableMap<K, V> tailMap(K fromKey, boolean inclusive) {
        return new SubsetNavigableMapView(this, this::getModCount, false, fromKey, inclusive, true, null, true, true);
    }

    @Override
    public @Nullable Comparator<? super K> comparator() {
        return this.comparator == NaturalComparator.instance() ? null : this.comparator;
    }

    @Override
    public @NonNull SortedMap<K, V> subMap(K fromKey, K toKey) {
        return this.subMap(fromKey, true, toKey, false);
    }

    @Override
    public @NonNull SortedMap<K, V> headMap(K toKey) {
        return this.headMap(toKey, true);
    }

    @Override
    public @NonNull SortedMap<K, V> tailMap(K fromKey) {
        return this.tailMap(fromKey, true);
    }

    @Override
    public K firstKey() {
        Map.Entry<K, V> entry = this.firstEntry();
        if (entry == null) {
            throw new NoSuchElementException();
        }
        return entry.getKey();
    }

    @Override
    public K lastKey() {
        Map.Entry<K, V> entry = this.lastEntry();
        if (entry == null) {
            throw new NoSuchElementException();
        }
        return entry.getKey();
    }

    @Override
    public int size() {
        return this.root.size();
    }

    @Override
    public boolean containsKey(Object key) {
        return this.root.contains((K)key, this.comparator);
    }

    @Override
    public boolean containsValue(Object value) {
        for (Node<K, V> node : this.root) {
            if (!Objects.equals(value, node.getValue())) continue;
            return true;
        }
        return false;
    }

    @Override
    public @Nullable V get(Object key) {
        return this.root.find((K)key, this.comparator).valueOrNull();
    }

    @Override
    public @Nullable V put(K key, V value) {
        RedBlackTree<K, V> newRoot = this.root.insert((K)key, value, this.comparator);
        if (newRoot != this.root) {
            if (newRoot.size() != this.root.size()) {
                ++this.modCount;
            }
            V oldValue = newRoot.size() == this.root.size() ? (V)this.root.find((K)key, this.comparator).getValue() : null;
            this.root = newRoot;
            return oldValue;
        }
        return null;
    }

    @Override
    public @Nullable V remove(Object key) {
        RedBlackTree<? super K, V> newRoot = this.root.delete((K)key, this.comparator);
        if (newRoot != this.root) {
            ++this.modCount;
            V oldValue = this.root.find((K)key, this.comparator).getValue();
            this.root = newRoot;
            return oldValue;
        }
        return null;
    }

    @Override
    public void clear() {
        if (!this.isEmpty()) {
            this.root = RedBlackTree.empty();
        }
    }

    private void iteratorPutIfPresent(@Nullable K k, @Nullable V v) {
        if (this.containsKey(k)) {
            this.put(k, v);
        }
    }

    private void iteratorRemove(Map.Entry<K, V> entry) {
        this.remove(entry.getKey());
    }

    public RedBlackMap<K, V> toImmutable() {
        return new RedBlackMap<K, V>(this.root, this.comparator);
    }

    @Override
    public @NonNull Iterator<Map.Entry<K, V>> iterator() {
        return new FailFastIterator<Map.Entry<K, V>>(new MappedIterator<MutableMapEntry, Node>(this.root.iterator(), e -> new MutableMapEntry<Object, Object>(this::iteratorPutIfPresent, e.getKey(), e.getValue())), this::iteratorRemove, this::getModCount);
    }

    @NonNull Iterator<Map.Entry<K, V>> reverseIterator() {
        return new FailFastIterator<Map.Entry<K, V>>(new MappedIterator<MutableMapEntry, Node>(this.root.reverseIterator(), e -> new MutableMapEntry<Object, Object>(this::iteratorPutIfPresent, e.getKey(), e.getValue())), this::iteratorRemove, this::getModCount);
    }

    @Override
    public @NonNull Spliterator<Map.Entry<K, V>> spliterator() {
        Spliterator<Node<K, V>> spliterator = Spliterators.spliterator(this.root.iterator(), (long)this.size(), 0x100 | this.characteristics());
        return new FailFastSpliterator<Map.Entry<K, V>>(spliterator, this::getModCount, this.comparator == NaturalComparator.instance() ? null : Map.Entry.comparingByKey(this.comparator));
    }

    @Override
    public @NonNull Set<Map.Entry<K, V>> entrySet() {
        return new SetFacade<Map.Entry<K, V>>(this::iterator, this::spliterator, this::size, this::containsEntry, this::clear, null, this::removeEntry);
    }

    @Override
    public @NonNull Set<K> keySet() {
        return new SetFacade(() -> new MappedIterator<Object, Map.Entry>(this.iterator(), Map.Entry::getKey), () -> new MappedSpliterator<Object, Map.Entry>(this.spliterator(), Map.Entry::getKey, this.characteristics(), this.comparator()), this::size, this::containsKey, this::clear, null, this::removeKey);
    }

    @Override
    public @NonNull Collection<V> values() {
        return new CollectionFacade(() -> new MappedIterator<Object, Map.Entry>(this.iterator(), Map.Entry::getValue), () -> new MappedSpliterator<Object, Map.Entry>(this.spliterator(), Map.Entry::getValue, this.characteristics() & 0xFFFFFEFE, null), this::size, this::containsKey, this::clear, null, this::removeKey);
    }

    private boolean removeEntry(@Nullable Object o) {
        if (this.containsEntry(o)) {
            assert (o != null);
            this.remove(((Map.Entry)o).getKey());
            return true;
        }
        return false;
    }

    private boolean removeKey(@Nullable Object o) {
        if (this.containsKey(o)) {
            this.remove(o);
            return true;
        }
        return false;
    }

    @Override
    public V getOrDefault(@NonNull Object key, V defaultValue) {
        return super.getOrDefault(key, defaultValue);
    }

    public void putAll(Iterable<? extends Map.Entry<? extends K, ? extends V>> m) {
        for (Map.Entry<K, V> e : m) {
            this.put(e.getKey(), e.getValue());
        }
    }

    private @NonNull Object writeReplace() throws ObjectStreamException {
        return new SerializationProxy(this);
    }

    private static class SerializationProxy<K, V>
    extends SortedMapSerializationProxy<K, V> {
        private static final long serialVersionUID = 0L;

        protected SerializationProxy(SortedMap<K, V> target) {
            super(target);
        }

        @Override
        protected @NonNull Object readResolve() {
            MutableRedBlackMap m = new MutableRedBlackMap(this.deserializedComparator);
            m.putAll(this.deserializedEntries);
            return m;
        }
    }
}

